<?php


if ( ! defined( 'ABSPATH' ) ) {
    exit;
} // Exit if accessed directly



class APPMAKER_WC_collivery_fields {

    var $count=0;
    public function __construct() {
        add_filter( 'appmaker_wc_checkout_fields', array( $this, 'checkout_fields' ),10, 2 );
        add_filter( 'appmaker_wc_dependency_billing_suburb', array( $this, 'suburb_dependency' ), 10, 2 );
        add_filter( 'appmaker_wc_dependency_shipping_suburb', array( $this, 'suburb_dependency' ), 10, 2 );
    }

    /**
     * @param $fields
     * @param $section
     *
     * @return array|mixed
     * @internal param array $args
     *
     */
    public function checkout_fields( $fields, $section ) {
        if ( 'billing' === $section || 'shipping' === $section ) {
            $fields[ $section . '_suburb' ]['type']      = 'dependent-select';
            $fields[ $section . '_suburb' ]['options']   = $this->get_suburbs($section);
            $fields[ $section . '_suburb' ]['dependent'] = true;
        }
        return $fields;
    }

    public function get_suburbs($section){
        return json_decode('{"Abbotsdale":{"items":{"CBD":"CBD"}},"Aberdeen":{"items":{"CBD":"CBD","Estoire":"Estoire"}},"Acornhoek":{"items":{"CBD":"CBD"}},"Adams Mission":{"items":{"CBD":"CBD"}},"Addo":{"items":{"CBD":"CBD"}},"Adelaide":{"items":{"CBD":"CBD"}},"Afguns":{"items":{"CBD":"CBD"}},"Aggeneys":{"items":{"CBD":"CBD"}},"Agulhas":{"items":{"CBD":"CBD"}},"Airforce Base Makhado (Braambos)":{"items":{"CBD":"CBD"}},"Akron":{"items":{"CBD":"CBD"}},"Albert Falls":{"items":{"CBD":"CBD"}},"Albertinia":{"items":{"CBD":"CBD"}},"Albinia":{"items":{"CBD":"CBD"}},"Alexander Bay":{"items":{"CBD":"CBD"}},"Alexandria EC":{"items":{"CBD":"CBD"}},"Alice":{"items":{"CBD":"CBD"}},"Alicedale":{"items":{"CBD":"CBD"}},"Aliwal North":{"items":{"CBD":"CBD"}},"Alkmaar":{"items":{"CBD":"CBD"}},"Allanridge":{"items":{"CBD":"CBD"}},"Alldays":{"items":{"CBD":"CBD"}},"Allemansdrift-C":{"items":{"CBD":"CBD"}},"Alma":{"items":{"CBD":"CBD"}},"Amabele":{"items":{"CBD":"CBD"}},"Amalia":{"items":{"CBD":"CBD"}},"Amandabult":{"items":{"CBD":"CBD","Chromite":"Chromite"}},"Amandelbult":{"items":{"CBD":"CBD"}},"Amanzimtoti":{"items":{"Althone Park":"Althone Park","CBD":"CBD"}},"Amatikulu":{"items":{"CBD":"CBD"}},"Amersfoort":{"items":{"CBD":"CBD"}},"Amsterdam":{"items":{"CBD":"CBD"}},"Andriesvale":{"items":{"CBD":"CBD"}},"Anerley":{"items":{"CBD":"CBD"}},"Apel":{"items":{"CBD":"CBD"}},"Arlington":{"items":{"CBD":"CBD"}},"Arniston":{"items":{"CBD":"CBD"}},"Arnot":{"items":{"CBD":"CBD"}},"Arthur Taylor Mine":{"items":{"CBD":"CBD"}},"Ashton":{"items":{"Ashton Outlying":"Ashton Outlying","CBD":"CBD","New Look":"New Look","Sandvliet":"Sandvliet","Zolani":"Zolani"}},"Askham":{"items":{"CBD":"CBD"}},"Aston Bay":{"items":{"CBD":"CBD"}},"Atamelang":{"items":{"CBD":"CBD"}},"Athole":{"items":{"CBD":"CBD"}},"Atlantic Beach Estate":{"items":{"CBD":"CBD"}},"Atlantis":{"items":{"Atlantis Indstrial":"Atlantis Indstrial","CBD":"CBD"}},"Atok":{"items":{"CBD":"CBD"}},"Atteridgeville - PTA":{"items":{"CBD":"CBD"}},"Augrabies":{"items":{"CBD":"CBD"}},"Aurora":{"items":{"CBD":"CBD"}},"Austrey":{"items":{"CBD":"CBD"}},"Avondster":{"items":{"CBD":"CBD"}},"Avontuur":{"items":{"CBD":"CBD"}},"Azaadville":{"items":{"CBD":"CBD"}},"Babanango":{"items":{"CBD":"CBD"}},"Babelegie":{"items":{"CBD":"CBD"}},"Badplaas":{"items":{"CBD":"CBD"}},"Bainsvlei":{"items":{"CBD":"CBD"}},"Bakerville":{"items":{"CBD":"CBD"}},"Balfour":{"items":{"CBD":"CBD"}},"Balfour, Eastern Cape":{"items":{"CBD":"CBD"}},"Balgowan":{"items":{"CBD":"CBD"}},"Ballito":{"items":{"CBD":"CBD","Compensation":"Compensation","Shakas Head":"Shakas Head","Shakas Rock":"Shakas Rock","Sheffield Beach":"Sheffield Beach"}},"Balmoral":{"items":{"CBD":"CBD"}},"Baltimore":{"items":{"CBD":"CBD"}},"Banana Beach":{"items":{"CBD":"CBD"}},"Bandalierskop":{"items":{"CBD":"CBD"}},"Bapong":{"items":{"CBD":"CBD"}},"Bapsfontein":{"items":{"CBD":"CBD"}},"Barberspan":{"items":{"CBD":"CBD"}},"Barberton":{"items":{"CBD":"CBD"}},"Barkly East":{"items":{"CBD":"CBD"}},"Barkly West":{"items":{"CBD":"CBD"}},"Barrydale":{"items":{"CBD":"CBD"}},"Bashewa AH":{"items":{"CBD":"CBD"}},"Batho-Batho":{"items":{"CBD":"CBD"}},"Bathurst":{"items":{"CBD":"CBD"}},"Bazley Beach":{"items":{"CBD":"CBD"}},"Beaufort West":{"items":{"CBD":"CBD"}},"Bedford":{"items":{"CBD":"CBD"}},"Beeshoek":{"items":{"CBD":"CBD"}},"Beestekraal":{"items":{"CBD":"CBD"}},"Beit Bridge":{"items":{"CBD":"CBD"}},"Bela Bela":{"items":{"CBD":"CBD"}},"Belfast":{"items":{"CBD":"CBD"}},"Belhar":{"items":{"CBD":"CBD"}},"Bergville":{"items":{"CBD":"CBD"}},"Berlin":{"items":{"CBD":"CBD"}},"Bethal":{"items":{"CBD":"CBD","New Bethal East":"New Bethal East"}},"Bethanie":{"items":{"CBD":"CBD"}},"Bethlehem":{"items":{"CBD":"CBD"}},"Bethulie":{"items":{"CBD":"CBD"}},"Bettys Bay":{"items":{"CBD":"CBD"}},"Biesiesvlei":{"items":{"CBD":"CBD"}},"Bisho":{"items":{"CBD":"CBD"}},"Bitterfontein":{"items":{"CBD":"CBD"}},"Bizana":{"items":{"CBD":"CBD"}},"Black Rock":{"items":{"CBD":"CBD"}},"Blinkpan":{"items":{"CBD":"CBD"}},"Bloemanda":{"items":{"CBD":"CBD"}},"Bloemedale":{"items":{"CBD":"CBD"}},"Bloemfontein":{"items":{"Arbortum":"Arbortum","Bainsvlei":"Bainsvlei","Batho":"Batho","Bayswater":"Bayswater","Bloemside":"Bloemside","Brandwag":"Brandwag","CBD":"CBD","Dan Pienaar":"Dan Pienaar","Estoire":"Estoire","Fauna":"Fauna","Fichardt Park":"Fichardt Park","Fleurdal":"Fleurdal","Freedom Square":"Freedom Square","Gardenia Park":"Gardenia Park","Generaal De Wet":"Generaal De Wet","Groenvlei":"Groenvlei","Hamilton":"Hamilton","Heidedal":"Heidedal","Helicon Heights":"Helicon Heights","Hellicon Park":"Hellicon Park","Heuwelsig":"Heuwelsig","Hillsboro":"Hillsboro","Hilton":"Hilton","Hospitaal Park":"Hospitaal Park","Lakeview":"Lakeview","Langenhoven Park":"Langenhoven Park","Langenhovenpark":"Langenhovenpark","Louriepark":"Louriepark","Naval Hill":"Naval Hill","Navalsig":"Navalsig","Noordhoek":"Noordhoek","Noordstad":"Noordstad","Ooseinde":"Ooseinde","Oranjesig":"Oranjesig","Park West":"Park West","Pellissier":"Pellissier","Pentagon Park":"Pentagon Park","Pentagonpark":"Pentagonpark","Phahameng":"Phahameng","Quaggafontein":"Quaggafontein","Rayton":"Rayton","Riverside Small Holdings":"Riverside Small Holdings","Rocklands":"Rocklands","Shellyvale":"Shellyvale","Tempe":"Tempe","Uitsig":"Uitsig","Universitas":"Universitas","Vaalbank":"Vaalbank","Waverley":"Waverley","Westdene":"Westdene","Wild Olive Estate":"Wild Olive Estate","Wilgehof":"Wilgehof","Wilgehof West":"Wilgehof West","Willows":"Willows","Woodland Estate":"Woodland Estate"}},"Bloemhof":{"items":{"Boitumelong":"Boitumelong","CBD":"CBD"}},"Bloemspruit":{"items":{"CBD":"CBD"}},"Blue Horison Bay":{"items":{"CBD":"CBD"}},"Blyvooruitsig":{"items":{"CBD":"CBD"}},"Bochum":{"items":{"CBD":"CBD"}},"Bodenstein":{"items":{"CBD":"CBD"}},"Boesmanskop":{"items":{"CBD":"CBD"}},"Boggoms Bay":{"items":{"CBD":"CBD"}},"Boikhutso":{"items":{"CBD":"CBD"}},"Boitekong":{"items":{"CBD":"CBD"}},"Bojanala":{"items":{"CBD":"CBD"}},"Boknes":{"items":{"CBD":"CBD"}},"Boknes Strand":{"items":{"CBD":"CBD"}},"Bollantlokwe":{"items":{"CBD":"CBD"}},"Bonnievale":{"items":{"CBD":"CBD"}},"Boons":{"items":{"CBD":"CBD"}},"Bosbokrand":{"items":{"CBD":"CBD"}},"Boschkop":{"items":{"CBD":"CBD"}},"Boshoek":{"items":{"CBD":"CBD"}},"Boshof":{"items":{"CBD":"CBD"}},"Boskuil":{"items":{"CBD":"CBD"}},"Bosplaas":{"items":{"CBD":"CBD"}},"Bospoort":{"items":{"CBD":"CBD"}},"Bothas Hill":{"items":{"CBD":"CBD"}},"Bothaville":{"items":{"CBD":"CBD"}},"Botrivier":{"items":{"CBD":"CBD"}},"Botshabelo":{"items":{"CBD":"CBD"}},"Bourkes Luck":{"items":{"CBD":"CBD"}},"Brakspruit":{"items":{"CBD":"CBD"}},"Brandfort":{"items":{"CBD":"CBD"}},"Brandvlei - GP":{"items":{"CBD":"CBD"}},"Brandvlei - NC":{"items":{"CBD":"CBD"}},"Bray":{"items":{"CBD":"CBD"}},"Bredasdorp":{"items":{"CBD":"CBD"}},"Breede River":{"items":{"CBD":"CBD"}},"Breerivier":{"items":{"CBD":"CBD"}},"Brenton-on-Sea":{"items":{"CBD":"CBD","Lake Brenton":"Lake Brenton"}},"Breyten":{"items":{"CBD":"CBD"}},"Brits":{"items":{"CBD":"CBD","Letlhhabile":"Letlhhabile","Mothotlung":"Mothotlung","Zandfontein":"Zandfontein"}},"Britstown":{"items":{"CBD":"CBD"}},"Broederstroom":{"items":{"CBD":"CBD"}},"Brondal":{"items":{"CBD":"CBD"}},"Bronkhorstspruit":{"items":{"CBD":"CBD"}},"Buffeljagsrivier":{"items":{"CBD":"CBD"}},"Buffels Bay":{"items":{"CBD":"CBD"}},"Buffelspoort":{"items":{"CBD":"CBD"}},"Buhrmansdrif":{"items":{"CBD":"CBD"}},"Bulletrap":{"items":{"CBD":"CBD"}},"Bultfontein":{"items":{"CBD":"CBD"}},"Bulwer":{"items":{"CBD":"CBD"}},"Burgersdorp":{"items":{"CBD":"CBD"}},"Burgersfort":{"items":{"CBD":"CBD","Praktiseer":"Praktiseer"}},"Bushbuckridge":{"items":{"CBD":"CBD"}},"Bushmans River":{"items":{"CBD":"CBD"}},"Butterworth":{"items":{"CBD":"CBD"}},"Byrne":{"items":{"CBD":"CBD"}},"Cala":{"items":{"CBD":"CBD"}},"Caledon":{"items":{"CBD":"CBD"}},"Calitzdorp":{"items":{"CBD":"CBD"}},"Calvinia":{"items":{"CBD":"CBD"}},"Camden":{"items":{"CBD":"CBD"}},"Campbell":{"items":{"CBD":"CBD"}},"Camperdown":{"items":{"CBD":"CBD"}},"Cannon Rocks":{"items":{"CBD":"CBD"}},"Cape St Francis":{"items":{"CBD":"CBD"}},"Cape Town":{"items":{"Aanhoe Wen":"Aanhoe Wen","Acacia Park":"Acacia Park","Admirals Park":"Admirals Park","Adriaanse":"Adriaanse","Airlie":"Airlie","Airport":"Airport","Airport industria":"Airport industria","Alora":"Alora","Alphen":"Alphen","Altydgedacht":"Altydgedacht","Amanda Glen":"Amanda Glen","Amandelrug":"Amandelrug","Amstelhof":"Amstelhof","Amsterdam":"Amsterdam","Andas Estate":"Andas Estate","Anesta":"Anesta","Arauna":"Arauna","Arbeidsgenot":"Arbeidsgenot","Arbeidslus":"Arbeidslus","Athlone":"Athlone","Aurora":"Aurora","Austinville":"Austinville","Avon":"Avon","Avondale":"Avondale","Avonwood":"Avonwood","Bakoven":"Bakoven","Balvenie":"Balvenie","Bane Township":"Bane Township","Bantry Bay":"Bantry Bay","Barbarossa":"Barbarossa","Bay Park":"Bay Park","Bay View Village":"Bay View Village","Beacon Valley":"Beacon Valley","Beaconhill":"Beaconhill","Beaconvale":"Beaconvale","Bel Ombre":"Bel Ombre","Belgravia":"Belgravia","Belhar":"Belhar","Bellair":"Bellair","Bellavista":"Bellavista","Belle Constantia":"Belle Constantia","Bellevue":"Bellevue","Bellrail":"Bellrail","Bellville":"Bellville","Bellville Centre":"Bellville Centre","Bellville South":"Bellville South","Bellville South Industrial":"Bellville South Industrial","Belmont Park":"Belmont Park","Belthorn Estate":"Belthorn Estate","Belvedere":"Belvedere","Berbago":"Berbago","Bergsig":"Bergsig","Bergvliet":"Bergvliet","Beroma":"Beroma","Bethanie":"Bethanie","Beverly":"Beverly","Big Bay":"Big Bay","Bishop Lavis":"Bishop Lavis","Bishopscourt":"Bishopscourt","Blaauwberg":"Blaauwberg","Blackheath Industrial":"Blackheath Industrial","Bloekombos":"Bloekombos","Bloemhof":"Bloemhof","Blombosvlei":"Blombosvlei","Blommendal":"Blommendal","Blomtuin":"Blomtuin","Blouberg Rise":"Blouberg Rise","Bloubergrant":"Bloubergrant","Bloubergstrand":"Bloubergstrand","Blouvlei":"Blouvlei","Blue Downs":"Blue Downs","Bo Dalsig":"Bo Dalsig","Bo-Oakdale":"Bo-Oakdale","Bongweni":"Bongweni","Bonnie Brae":"Bonnie Brae","Bonnie Brook":"Bonnie Brook","Bonteheuwel":"Bonteheuwel","Boquinar":"Boquinar","Boquinar Industrial Area":"Boquinar Industrial Area","Borcherds Quarry":"Borcherds Quarry","Bosmans Estate":"Bosmans Estate","Bosonia":"Bosonia","Boston":"Boston","Bothasig":"Bothasig","Bracken Heights":"Bracken Heights","Brackenfell":"Brackenfell","Brackenfell Industria":"Brackenfell Industria","Brae View":"Brae View","Brandwacht":"Brandwacht","Brandwag":"Brandwag","Brantwood":"Brantwood","Brentwood Park":"Brentwood Park","Bridgebank":"Bridgebank","Bridgetown":"Bridgetown","Bridgewater":"Bridgewater","Briza":"Briza","Briza Township":"Briza Township","Brooklyn":"Brooklyn","Browns Farm":"Browns Farm","Burgundy Estate":"Burgundy Estate","Cafda Village":"Cafda Village","Camelot":"Camelot","Camps Bay":"Camps Bay","Canwwick":"Canwwick","Cape Farms":"Cape Farms","Cape Town City Centre":"Cape Town City Centre","Capri":"Capri","Cedardale":"Cedardale","Century City":"Century City","Chantecler":"Chantecler","Chapmans Peak":"Chapmans Peak","Charleston Hill":"Charleston Hill","Charlesville":"Charlesville","Chrismar":"Chrismar","Churchhill":"Churchhill","Clam Hall":"Clam Hall","Claremont":"Claremont","Clarkes":"Clarkes","Clifton":"Clifton","Cloetesville":"Cloetesville","Clovelly":"Clovelly","Clunie":"Clunie","Colorado":"Colorado","Connaught":"Connaught","Constantia":"Constantia","Constantia Hghts":"Constantia Hghts","Constantia Vale":"Constantia Vale","Constantia Vlge":"Constantia Vlge","Cravenby":"Cravenby","Crawford":"Crawford","Crofters Valley":"Crofters Valley","Croydon Vineyard Estate":"Croydon Vineyard Estate","Culemborg":"Culemborg","Da Gama Park":"Da Gama Park","Dal Josafat Industrial Township":"Dal Josafat Industrial Township","Dalsig":"Dalsig","Dalvale":"Dalvale","Danarand":"Danarand","Danena":"Danena","Danneburg":"Danneburg","Dassiesfontein":"Dassiesfontein","De Bron":"De Bron","De Duin":"De Duin","De Kuilen":"De Kuilen","De La Haye":"De La Haye","De Oude Renbaan":"De Oude Renbaan","De Tijger":"De Tijger","De Tuin":"De Tuin","De Waterkant":"De Waterkant","De Zoete Inval":"De Zoete Inval","Delft":"Delft","Delft South":"Delft South","Delro":"Delro","Denemere":"Denemere","Deurdrif":"Deurdrif","Devils Peak Estate":"Devils Peak Estate","Devon Park":"Devon Park","Devonvallei":"Devonvallei","Dido Valley":"Dido Valley","Die Boord":"Die Boord","Die Bos":"Die Bos","Die Rand":"Die Rand","Diep River":"Diep River","Dobson":"Dobson","Door De Kraal":"Door De Kraal","Doornhoogte":"Doornhoogte","Dorhill":"Dorhill","DR. Malan":"DR. Malan","Dreyersdal":"Dreyersdal","Drosty Park":"Drosty Park","Due Werf":"Due Werf","Dunoon":"Dunoon","Dunrobin":"Dunrobin","Durbanville":"Durbanville","Durbanville Hlls":"Durbanville Hlls","Durbell":"Durbell","Durrheim":"Durrheim","Duynefontein":"Duynefontein","Duynefontien":"Duynefontien","Eagles Nest":"Eagles Nest","Eastridge":"Eastridge","Eastrock":"Eastrock","Eden":"Eden","Edenpark":"Edenpark","Edgemead":"Edgemead","Edward":"Edward","Eersterivier":"Eersterivier","Eikenbosch":"Eikenbosch","Eikendal":"Eikendal","Eindhoven":"Eindhoven","Eldawn":"Eldawn","Electric City":"Electric City","Elfindale":"Elfindale","Elim":"Elim","Elnor":"Elnor","Elriche":"Elriche","Elsiesrivier":"Elsiesrivier","Elsiesrivier Industrial Area":"Elsiesrivier Industrial Area","Epping Forest":"Epping Forest","Epping Garden Village":"Epping Garden Village","Epping Industria 1":"Epping Industria 1","Epping Industria 2":"Epping Industria 2","Erinvale Estate":"Erinvale Estate","Eskom":"Eskom","Everglen":"Everglen","Eversdal":"Eversdal","Eversdal Heights":"Eversdal Heights","Ex - Skool":"Ex - Skool","Ex - Stasie":"Ex - Stasie","Factreton":"Factreton","Faerie Knowe":"Faerie Knowe","Fairdale":"Fairdale","Fairfield Estate":"Fairfield Estate","Fairways":"Fairways","Fairyland":"Fairyland","Faure":"Faure","Ferndale":"Ferndale","Ferness":"Ferness","Fir Grove":"Fir Grove","Firgrove":"Firgrove","Fish Hoek":"Fish Hoek","Flamingo Vlei":"Flamingo Vlei","Flintdale Estate":"Flintdale Estate","Florida":"Florida","Forbeslincoln":"Forbeslincoln","Foreshore":"Foreshore","Forest Glade":"Forest Glade","Forest Village":"Forest Village","Fountain Village":"Fountain Village","Fraaigelegen":"Fraaigelegen","Frere Estate":"Frere Estate","Fresnaye":"Fresnaye","Froggy Farm":"Froggy Farm","Frogmore Estate":"Frogmore Estate","Gardens":"Gardens","Gatesville":"Gatesville","Gaylands":"Gaylands","Gaylee":"Gaylee","Gersham":"Gersham","Gill Cape":"Gill Cape","Gleemoor":"Gleemoor","Glen Abbot":"Glen Abbot","Glen Alpine":"Glen Alpine","Glen Ive":"Glen Ive","Glen Lily":"Glen Lily","Glen Marine":"Glen Marine","Glen Ridge":"Glen Ridge","Glen Valley":"Glen Valley","Glencairn":"Glencairn","Glencairn Heights":"Glencairn Heights","Glenhaven":"Glenhaven","Glenview":"Glenview","Goede Hoop":"Goede Hoop","Goedemoed":"Goedemoed","Golden Acre":"Golden Acre","Golden Hill":"Golden Hill","Goodwood":"Goodwood","Goodwood Estate":"Goodwood Estate","Gordon Heights":"Gordon Heights","Gordon Strand":"Gordon Strand","Granger Bay":"Granger Bay","Grassy Park":"Grassy Park","Green Oaks":"Green Oaks","Green Point":"Green Point","Greenfield":"Greenfield","Greenlands":"Greenlands","Greenway Rise":"Greenway Rise","Greenways":"Greenways","Griselda":"Griselda","Groendal":"Groendal","Groenheuwel":"Groenheuwel","Groenvallei":"Groenvallei","Groenvlei":"Groenvlei","Groot Bosch":"Groot Bosch","Groot Oukraal":"Groot Oukraal","Groote Schuur Estate":"Groote Schuur Estate","Guldenland":"Guldenland","Gustrouw":"Gustrouw","Hagley":"Hagley","Haialie":"Haialie","Hampton Estate":"Hampton Estate","Hanover Park":"Hanover Park","Harbour Island":"Harbour Island","Harrington\'s Place":"Harrington\'s Place","Hazelwood Park":"Hazelwood Park","Hazendal":"Hazendal","Heather Park":"Heather Park","Heathfield":"Heathfield","Heemstede Estate":"Heemstede Estate","Heideveld":"Heideveld","Heldeberg":"Heldeberg","Heldeberg Estate":"Heldeberg Estate","Heldeberg Village":"Heldeberg Village","Helderrand":"Helderrand","Helderzicht":"Helderzicht","Helena Heights":"Helena Heights","Helgarda Estate":"Helgarda Estate","High Constantia":"High Constantia","High Gate":"High Gate","Highbury":"Highbury","Highlands Estate":"Highlands Estate","Highveld":"Highveld","Hillcrest Heights":"Hillcrest Heights","Hillrise":"Hillrise","Hillview":"Hillview","Hindle Park":"Hindle Park","Hoheizen":"Hoheizen","Hohenort":"Hohenort","Hoogstede":"Hoogstede","Hope Of Constantia":"Hope Of Constantia","Hout Bay":"Hout Bay","Hout Bay Harbour":"Hout Bay Harbour","Huis-in-Bos":"Huis-in-Bos","Idasvallei":"Idasvallei","Ikwezi Park":"Ikwezi Park","Illaire":"Illaire","Imhoff\'s Gift":"Imhoff\'s Gift","Imizamo Yethu":"Imizamo Yethu","Jacques Hill Estate":"Jacques Hill Estate","Jagershof":"Jagershof","Jonkershoogte":"Jonkershoogte","Jonkerspark":"Jonkerspark","Joostenberg Vlakte":"Joostenberg Vlakte","Kaapzicht":"Kaapzicht","Kalamuda":"Kalamuda","Kalk Bay":"Kalk Bay","Kalksteenfontein":"Kalksteenfontein","Kanever":"Kanever","Kanonberg":"Kanonberg","Karindal":"Karindal","Katzenberg":"Katzenberg","Kayamandi":"Kayamandi","Kaymor":"Kaymor","Kempenville":"Kempenville","Kenilworth":"Kenilworth","Kenridge":"Kenridge","Kenridge Durbanville":"Kenridge Durbanville","Kenridge Heights":"Kenridge Heights","Kensington":"Kensington","Kenwyn":"Kenwyn","Kewtown":"Kewtown","Killarney Gardens":"Killarney Gardens","Killarney Industria":"Killarney Industria","Kirstenhof":"Kirstenhof","Klassenbosch":"Klassenbosch","Klassenbosch Heights":"Klassenbosch Heights","Klein Begin":"Klein Begin","Klein Constantia":"Klein Constantia","Klein Drakenstein":"Klein Drakenstein","Klein Nederberg":"Klein Nederberg","Klein Nederburg":"Klein Nederburg","Klein Wassenaar":"Klein Wassenaar","Kleinbos":"Kleinbos","Kleinbosch":"Kleinbosch","Kleinbron Park":"Kleinbron Park","Kleingeluk":"Kleingeluk","Kleinvlei":"Kleinvlei","Klipdam":"Klipdam","Klipheuwel":"Klipheuwel","Klipkop":"Klipkop","Knole Park":"Knole Park","Koeberg":"Koeberg","Kommetjie":"Kommetjie","Kraaifontein":"Kraaifontein","Kraaifontein Industria":"Kraaifontein Industria","Krigeville":"Krigeville","Kromrivier":"Kromrivier","Kuils River":"Kuils River","La Colline":"La Colline","La Rochelle":"La Rochelle","La Sandra":"La Sandra","Labiance":"Labiance","Lakeside":"Lakeside","Land en Zeezicht":"Land en Zeezicht","Landsdowne":"Landsdowne","Langeberg Ridge":"Langeberg Ridge","Langeberg Village":"Langeberg Village","Langgewacht":"Langgewacht","Lansdowne":"Lansdowne","Lanstead":"Lanstead","Laurindale":"Laurindale","Lavender Hill":"Lavender Hill","Lekkrwater":"Lekkrwater","Lentegeur":"Lentegeur","Leonsdale":"Leonsdale","Lieberheim":"Lieberheim","Lindida":"Lindida","Lionviham":"Lionviham","Little Chelsea":"Little Chelsea","Llandudno":"Llandudno","Lochiel":"Lochiel","Lochnerhof":"Lochnerhof","Loevenstein":"Loevenstein","Longdown Estate":"Longdown Estate","Longlands":"Longlands","Lotus River":"Lotus River","Loumar":"Loumar","Lusthof":"Lusthof","Lynn\'s View":"Lynn\'s View","Mabille Park":"Mabille Park","Macassar":"Macassar","Macassar Beach":"Macassar Beach","Maitland":"Maitland","Maitland Garden Village":"Maitland Garden Village","Malibu Village":"Malibu Village","Mandalay":"Mandalay","Manenberg":"Manenberg","Marconi Beam":"Marconi Beam","Marina Da Gama":"Marina Da Gama","Marinda Heights":"Marinda Heights","Marlborough Park":"Marlborough Park","Marlow":"Marlow","Martinville":"Martinville","Matroosfontein":"Matroosfontein","Maycape":"Maycape","Mbekweni":"Mbekweni","Meadowridge":"Meadowridge","Melkbosstrand":"Melkbosstrand","Metro Industrial Township":"Metro Industrial Township","Mfuleni":"Mfuleni","Mikro Park":"Mikro Park","Milnerton":"Milnerton","Milnerton Ridge":"Milnerton Ridge","Mimosa":"Mimosa","Mitchells Plain":"Mitchells Plain","Moddersdam Peninsula":"Moddersdam Peninsula","Mogenster Hoogte":"Mogenster Hoogte","Montagu\'s Gift":"Montagu\'s Gift","Montague Gardens":"Montague Gardens","Montana\/Durrheim":"Montana\/Durrheim","Montclair":"Montclair","Monte Sereno":"Monte Sereno","Monte Vista":"Monte Vista","Montevideo":"Montevideo","Morgenster":"Morgenster","Morgenster Hoogte":"Morgenster Hoogte","Morningside":"Morningside","Morningstar":"Morningstar","Mostetrdrift":"Mostetrdrift","Mouille Point":"Mouille Point","Mount Pleasant":"Mount Pleasant","Mountaiview":"Mountaiview","Mowbray":"Mowbray","Muizenberg":"Muizenberg","Murdock Valley":"Murdock Valley","N1 City":"N1 City","Natures Valley":"Natures Valley","Ndabeni":"Ndabeni","Nerissa Estate":"Nerissa Estate","New Orleans":"New Orleans","Newfields":"Newfields","Newlands":"Newlands","Newton":"Newton","Nieuw Maastrecht":"Nieuw Maastrecht","Nieuw Nooiensfontein":"Nieuw Nooiensfontein","Nomzano":"Nomzano","Nooiensfontein":"Nooiensfontein","Nooitgedagcht":"Nooitgedagcht","Noordhoek":"Noordhoek","Northgate":"Northgate","Northpine":"Northpine","Norwood":"Norwood","Nothern Paarl":"Nothern Paarl","Nova Constantia":"Nova Constantia","Nutwood":"Nutwood","O\' Kennedyville":"O\' Kennedyville","Oak Glen":"Oak Glen","Oakdale":"Oakdale","Oakdale Industrial":"Oakdale Industrial","Oakdene":"Oakdene","Observatory":"Observatory","Ocean View":"Ocean View","Octovale":"Octovale","Okavango Park":"Okavango Park","Old Sillery":"Old Sillery","Onderpapegaaiberg":"Onderpapegaaiberg","Onverwacht":"Onverwacht","Oostenberg":"Oostenberg","Oostersee":"Oostersee","Oranjezicht":"Oranjezicht","Ottery":"Ottery","Ottery East":"Ottery East","Ottery Gardens":"Ottery Gardens","Ottery Station":"Ottery Station","Otyhouse Estate":"Otyhouse Estate","Oude Westhof":"Oude Westhof","Oudekraal":"Oudekraal","Paarden Eiland":"Paarden Eiland","Paarlzicht":"Paarlzicht","Pagasvlei":"Pagasvlei","Palm Park":"Palm Park","Panorama":"Panorama","Paradyskloof":"Paradyskloof","Parel Vallei":"Parel Vallei","Park Estates":"Park Estates","Parklands":"Parklands","Parkwood":"Parkwood","Parow":"Parow","Parow East":"Parow East","Parow Industrial":"Parow Industrial","Parow North":"Parow North","Parowvallei":"Parowvallei","Pearl Marina":"Pearl Marina","Peerless Park East":"Peerless Park East","Peerless Park North":"Peerless Park North","Peerless Park West":"Peerless Park West","Pelikan Park":"Pelikan Park","Penhill":"Penhill","Penlyn Estate":"Penlyn Estate","Penzance Estate":"Penzance Estate","Perm Gardens":"Perm Gardens","Pinati":"Pinati","Pine Acres":"Pine Acres","Pine Place":"Pine Place","Pinehaven":"Pinehaven","Pinehurst":"Pinehurst","Pinelands":"Pinelands","Plankenburg":"Plankenburg","Plattekloof":"Plattekloof","Plattekloof Glen":"Plattekloof Glen","Plumstead":"Plumstead","Pollsmoor":"Pollsmoor","Porter Estate":"Porter Estate","Porter Reformatory Estate":"Porter Reformatory Estate","Portlands":"Portlands","Primrose Park":"Primrose Park","Proplan":"Proplan","Protea Hoogte":"Protea Hoogte","Protea Park":"Protea Park","Protea Village":"Protea Village","Proteavallei":"Proteavallei","Proteaville":"Proteaville","Punts Township":"Punts Township","Ravensmead":"Ravensmead","Retreat":"Retreat","Retreat Industrial Area":"Retreat Industrial Area","Richwood":"Richwood","Ridgeworth":"Ridgeworth","Riverton":"Riverton","Robinvale":"Robinvale","Rocklands":"Rocklands","Rome":"Rome","Rome Glen":"Rome Glen","Rompevlei":"Rompevlei","Rondebosch":"Rondebosch","Rondebosch East":"Rondebosch East","Rondevallei":"Rondevallei","Roosendal":"Roosendal","Rosebank":"Rosebank","Rosedale":"Rosedale","Rosendal":"Rosendal","Rosenpark":"Rosenpark","Roundhay":"Roundhay","Royal Cape":"Royal Cape","Rozendal":"Rozendal","Rugby":"Rugby","Russel\'s Rest":"Russel\'s Rest","Rust-En-Vrede":"Rust-En-Vrede","Rustdal":"Rustdal","Rustdale":"Rustdale","Rusthof":"Rusthof","Rutvale Estate":"Rutvale Estate","Ruwari":"Ruwari","Ruyterwacht":"Ruyterwacht","Rylands":"Rylands","Sack\'s Circle Industrial":"Sack\'s Circle Industrial","Saint James":"Saint James","Salberau":"Salberau","Salt River":"Salt River","San Michel":"San Michel","Sand Industria":"Sand Industria","Sanddrift":"Sanddrift","Sanlamhof":"Sanlamhof","Sarepta":"Sarepta","Saxon Industrial":"Saxon Industrial","Saxonsea":"Saxonsea","Scapp Kraal":"Scapp Kraal","Scarborough":"Scarborough","Schoongelegen":"Schoongelegen","Schotschekloof":"Schotschekloof","Schuilplaats":"Schuilplaats","Schusterskraal":"Schusterskraal","Scott Estate":"Scott Estate","Scottsdene":"Scottsdene","Scottsville":"Scottsville","Sea Point":"Sea Point","Seaforth":"Seaforth","Seebries":"Seebries","Sherwood":"Sherwood","Shirley Park":"Shirley Park","Sillery":"Sillery","Silverglade":"Silverglade","Silverhurst":"Silverhurst","Silvermine Village":"Silvermine Village","Silveroaks":"Silveroaks","Silversands":"Silversands","Silverstream":"Silverstream","Silvertown":"Silvertown","Silwood":"Silwood","Simons Town":"Simons Town","Simonswyk":"Simonswyk","Sir Lowrys Pass":"Sir Lowrys Pass","Skilpadvlei":"Skilpadvlei","Skoongesig":"Skoongesig","Somerset Park":"Somerset Park","Soneike":"Soneike","Sonnendal":"Sonnendal","Sonstraal":"Sonstraal","South Peninsula":"South Peninsula","Southfield":"Southfield","Southfork":"Southfork","Springbok Park":"Springbok Park","Springfield":"Springfield","St James":"St James","St. Dumas":"St. Dumas","St. Michaels":"St. Michaels","Stanlou":"Stanlou","Steenberg":"Steenberg","Steenberg1":"Steenberg1","Steenbras View":"Steenbras View","Steenburg":"Steenburg","Stellenberg":"Stellenberg","Stellenrigde":"Stellenrigde","Stellenrust":"Stellenrust","Stellenryk":"Stellenryk","Steynsrust":"Steynsrust","Stikland Industrial":"Stikland Industrial","Strand Halt":"Strand Halt","Strandfontein":"Strandfontein","Stratford":"Stratford","Stratford Green":"Stratford Green","Stuart Hill":"Stuart Hill","Summer Greens":"Summer Greens","Summerville":"Summerville","Sun Valley":"Sun Valley","Sunbird Park":"Sunbird Park","Sunlands":"Sunlands","Sunningdale":"Sunningdale","Sunny Acres":"Sunny Acres","Sunnydale":"Sunnydale","Sunnyside":"Sunnyside","Sunset Beach":"Sunset Beach","Sunset Glen":"Sunset Glen","Surrey":"Surrey","Sweet Valley":"Sweet Valley","Sweet Water":"Sweet Water","Sybrand Park":"Sybrand Park","Table View":"Table View","Tafelsig":"Tafelsig","Tamboerskloof":"Tamboerskloof","Tarentaalplaas":"Tarentaalplaas","Tatanga Junction":"Tatanga Junction","Tegno Park":"Tegno Park","Tembani":"Tembani","Temperance Town":"Temperance Town","Tennantville":"Tennantville","The Boulders":"The Boulders","The Conifers":"The Conifers","The Hague":"The Hague","The Lakes":"The Lakes","The Links":"The Links","The Paddocks":"The Paddocks","The Palms":"The Palms","The Range":"The Range","The Vines":"The Vines","The Wines":"The Wines","Thornton":"Thornton","Three Anchor Bay":"Three Anchor Bay","Tierboskloof":"Tierboskloof","Tijgerhof":"Tijgerhof","Tokai":"Tokai","Townsend Estate":"Townsend Estate","Triangle Farm":"Triangle Farm","Turf Hall":"Turf Hall","Turf Hall Estate":"Turf Hall Estate","Tuscany Glen":"Tuscany Glen","Tyger Valley":"Tyger Valley","Tygerberg":"Tygerberg","Tygerdal":"Tygerdal","Tygerfalls":"Tygerfalls","Uitkyk":"Uitkyk","Uitsig":"Uitsig","Uitzicht":"Uitzicht","Uniepark":"Uniepark","Universteits-Oord":"Universteits-Oord","V&A Waterfront":"V&A Waterfront","Valhalla":"Valhalla","Valmary Park":"Valmary Park","Van Der Stel":"Van Der Stel","Van Riebeckstrand":"Van Riebeckstrand","Van Riebeeckshof":"Van Riebeeckshof","Van Ryneveld":"Van Ryneveld","Vanguard":"Vanguard","Vasco Estate":"Vasco Estate","Vergesig":"Vergesig","Vierlanden Heights":"Vierlanden Heights","Village 1 Khayelitsha":"Village 1 Khayelitsha","Village Close":"Village Close","Voelvlei":"Voelvlei","Vogelvlei":"Vogelvlei","Voorbrug":"Voorbrug","Vosfontein":"Vosfontein","Vredehoek":"Vredehoek","Vredekloof":"Vredekloof","Vredekloof Heights":"Vredekloof Heights","Vredelust":"Vredelust","Vygeboom":"Vygeboom","Wallacedene":"Wallacedene","Walmer Estate":"Walmer Estate","Washington Square":"Washington Square","Webbervallei":"Webbervallei","Welcome":"Welcome","Welgedacht":"Welgedacht","Welgelee":"Welgelee","Welgelegen":"Welgelegen","Welgemoed":"Welgemoed","Wellway Park":"Wellway Park","Wellway Park East":"Wellway Park East","Weltevreden":"Weltevreden","Weltevreden Valley":"Weltevreden Valley","Wembley Park":"Wembley Park","Wesbank":"Wesbank","Wesfleur":"Wesfleur","West Beach":"West Beach","West Riding":"West Riding","Westlake":"Westlake","Westridge":"Westridge","Wetton":"Wetton","Whispering Pines":"Whispering Pines","White Waters":"White Waters","William Lloyd":"William Lloyd","Wimbledon":"Wimbledon","Windmeul":"Windmeul","Windsor Park":"Windsor Park","Windsor Park Est":"Windsor Park Est","Winford":"Winford","Wingfield":"Wingfield","Winslow":"Winslow","Winston Estate":"Winston Estate","Witsand":"Witsand","Witteboomen":"Witteboomen","Woodbridge Island":"Woodbridge Island","Woodlands":"Woodlands","Woodstock":"Woodstock","Worlds View":"Worlds View","Wynberg":"Wynberg","Yorkshire Estate":"Yorkshire Estate","Youngsfield":"Youngsfield","Ysterplaat":"Ysterplaat","Zandburg":"Zandburg","Zeekoevlei":"Zeekoevlei","Zerilda Park":"Zerilda Park","Zonnebloem":"Zonnebloem","Zoo Park":"Zoo Park","Zwartdam":"Zwartdam"}},"Carletonville":{"items":{"CBD":"CBD","Deelkraal":"Deelkraal","Oberholzer":"Oberholzer","Welverdiend AH":"Welverdiend AH"}},"Carnarvon":{"items":{"CBD":"CBD"}},"Carolina":{"items":{"CBD":"CBD"}},"Cathcart":{"items":{"CBD":"CBD"}},"Cathedral Peak":{"items":{"CBD":"CBD"}},"Cato Ridge":{"items":{"CBD":"CBD"}},"Cedara":{"items":{"CBD":"CBD"}},"Cedarville":{"items":{"CBD":"CBD"}},"Ceres":{"items":{"CBD":"CBD"}},"Champagne Castle Hotel":{"items":{"CBD":"CBD"}},"Charl Cilliers":{"items":{"CBD":"CBD"}},"Charlestown":{"items":{"CBD":"CBD"}},"Chatsworth, WC":{"items":{"CBD":"CBD"}},"Chintsa East":{"items":{"CBD":"CBD"}},"Chrissiesmeer":{"items":{"CBD":"CBD"}},"Christiana":{"items":{"CBD":"CBD","Utlwanang":"Utlwanang"}},"Christmas Rock":{"items":{"CBD":"CBD"}},"Cintsa":{"items":{"CBD":"CBD"}},"Citrusdal":{"items":{"CBD":"CBD"}},"Clanwilliam":{"items":{"CBD":"CBD"}},"Clarens":{"items":{"CBD":"CBD"}},"Clewer":{"items":{"CBD":"CBD"}},"Cliffdale":{"items":{"CBD":"CBD"}},"Clocolan":{"items":{"CBD":"CBD"}},"Coalville":{"items":{"CBD":"CBD"}},"Coffee Bay":{"items":{"CBD":"CBD"}},"Cofimvaba":{"items":{"CBD":"CBD"}},"Colchester":{"items":{"CBD":"CBD"}},"Colenso":{"items":{"CBD":"CBD"}},"Colesberg":{"items":{"CBD":"CBD"}},"Coligny":{"items":{"CBD":"CBD"}},"Concordia":{"items":{"CBD":"CBD"}},"Cookhouse":{"items":{"CBD":"CBD"}},"Cornelia":{"items":{"CBD":"CBD"}},"Cradock":{"items":{"CBD":"CBD"}},"Cramond":{"items":{"CBD":"CBD"}},"Creighton":{"items":{"CBD":"CBD"}},"Cullinan":{"items":{"CBD":"CBD"}},"Currys Post":{"items":{"CBD":"CBD"}},"Cyferfontein":{"items":{"CBD":"CBD"}},"Da Noon":{"items":{"CBD":"CBD"}},"Daantjie":{"items":{"CBD":"CBD"}},"Daggakraal":{"items":{"CBD":"CBD"}},"Dalmada":{"items":{"CBD":"CBD"}},"Dalton":{"items":{"CBD":"CBD"}},"Dana Bay":{"items":{"CBD":"CBD"}},"Danielskuil":{"items":{"CBD":"CBD"}},"Danielsrus":{"items":{"CBD":"CBD"}},"Dannhauser":{"items":{"CBD":"CBD"}},"Dargle":{"items":{"CBD":"CBD"}},"Darling":{"items":{"CBD":"CBD"}},"Darnall":{"items":{"CBD":"CBD"}},"Dassiefontein":{"items":{"CBD":"CBD"}},"Davel":{"items":{"CBD":"CBD"}},"Dayizenza Plaza":{"items":{"CBD":"CBD"}},"De Aar":{"items":{"CBD":"CBD"}},"De brug":{"items":{"CBD":"CBD"}},"De Doorns":{"items":{"CBD":"CBD"}},"De Grens":{"items":{"CBD":"CBD"}},"De Kelders":{"items":{"CBD":"CBD"}},"De Rust":{"items":{"CBD":"CBD"}},"De Wildt (Pretoria)":{"items":{"CBD":"CBD"}},"Dealesville":{"items":{"CBD":"CBD"}},"Delareyville":{"items":{"CBD":"CBD"}},"Delmas":{"items":{"CBD":"CBD","Eloff":"Eloff"}},"Delportshoop":{"items":{"CBD":"CBD"}},"Dendron":{"items":{"CBD":"CBD"}},"Deneysville":{"items":{"CBD":"CBD"}},"Dennilton":{"items":{"CBD":"CBD"}},"Derby":{"items":{"CBD":"CBD"}},"Despatch":{"items":{"CBD":"CBD","Retief":"Retief"}},"Devon":{"items":{"CBD":"CBD"}},"Dewetsdorp":{"items":{"CBD":"CBD"}},"Dibeng":{"items":{"CBD":"CBD"}},"Didima Ezemvelo KZNW Camp":{"items":{"CBD":"CBD"}},"Die Oog":{"items":{"CBD":"CBD"}},"Dihatshwane":{"items":{"CBD":"CBD"}},"Dihibidung":{"items":{"CBD":"CBD"}},"Dikebu":{"items":{"CBD":"CBD"}},"Dimbaza":{"items":{"CBD":"CBD"}},"Dingateng":{"items":{"CBD":"CBD"}},"Dinokana":{"items":{"CBD":"CBD"}},"Dipetlelwane":{"items":{"CBD":"CBD"}},"Disaneng":{"items":{"CBD":"CBD"}},"Dominionville":{"items":{"CBD":"CBD"}},"Donnybrook":{"items":{"CBD":"CBD"}},"Doonside":{"items":{"CBD":"CBD"}},"Doornlaagte":{"items":{"CBD":"CBD"}},"Doornpan":{"items":{"CBD":"CBD"}},"Dordrecht":{"items":{"CBD":"CBD"}},"Doringbaai":{"items":{"CBD":"CBD"}},"Douglas":{"items":{"CBD":"CBD"}},"Driefontein":{"items":{"CBD":"CBD"}},"Driekop":{"items":{"CBD":"CBD"}},"Drummond":{"items":{"CBD":"CBD"}},"Dudfield":{"items":{"CBD":"CBD"}},"Duduza":{"items":{"CBD":"CBD"}},"Dullstroom":{"items":{"CBD":"CBD"}},"Dundee":{"items":{"CBD":"CBD"}},"Dundonald":{"items":{"CBD":"CBD"}},"Durban":{"items":{"Acorn":"Acorn","Addington":"Addington","Airport":"Airport","Albany":"Albany","Albinia":"Albinia","Alexander Park":"Alexander Park","Amanzimtoti":"Amanzimtoti","Angola":"Angola","Arena Park":"Arena Park","Asherville":"Asherville","Ashley":"Ashley","Assagay":"Assagay","Astra Park":"Astra Park","Athlone":"Athlone","Athlone Park":"Athlone Park","Atholl Heights":"Atholl Heights","Atholton":"Atholton","Austerville":"Austerville","Avoca":"Avoca","Avoca Hills":"Avoca Hills","Ballito":"Ballito","Barnes":"Barnes","Barrs Flats":"Barrs Flats","Bayhead":"Bayhead","Bayview":"Bayview","Beachfront":"Beachfront","Beachwood":"Beachwood","Bellair":"Bellair","Belvedere":"Belvedere","Belvedere Hillcrest":"Belvedere Hillcrest","Belvedere Tongaat":"Belvedere Tongaat","Berea":"Berea","Berea West":"Berea West","Berkshire Downs":"Berkshire Downs","Berrell":"Berrell","Beverly Hills":"Beverly Hills","Bhekukutulu":"Bhekukutulu","Birchwood":"Birchwood","Blackburn":"Blackburn","Blackburn Estate":"Blackburn Estate","Bluff":"Bluff","Bonela":"Bonela","Botha\'s Hill":"Botha\'s Hill","Briardene":"Briardene","Bridge Park":"Bridge Park","Brighton Beach":"Brighton Beach","Brindhaven":"Brindhaven","Broadway":"Broadway","Brookdale":"Brookdale","Buena Vista":"Buena Vista","Buffels Bosch":"Buffels Bosch","Buffelsdale":"Buffelsdale","Buffelsdraai":"Buffelsdraai","Bul-Bul":"Bul-Bul","Bulwer":"Bulwer","Burbreeze":"Burbreeze","Burlington Heights":"Burlington Heights","Burnside":"Burnside","Caliph":"Caliph","Canelands":"Canelands","Canelands Industrial":"Canelands Industrial","Caneside":"Caneside","Carrington Heights":"Carrington Heights","Castle Hill":"Castle Hill","Caversham Glen":"Caversham Glen","Cemtenery Park":"Cemtenery Park","Chatsworth":"Chatsworth","Chatsworth Town Centre":"Chatsworth Town Centre","Chelmsford Heights":"Chelmsford Heights","Chelmsfordville":"Chelmsfordville","Chesterville":"Chesterville","Chiltern Hills":"Chiltern Hills","Clairwood":"Clairwood","Clayfield":"Clayfield","Clere Hills":"Clere Hills","Clermont":"Clermont","Clifton Park":"Clifton Park","Clover Dairies Industrial":"Clover Dairies Industrial","Coffe Farm":"Coffe Farm","Congella":"Congella","Cordoba Gardens":"Cordoba Gardens","Cornubia":"Cornubia","Corovoca Township":"Corovoca Township","Cottonlands":"Cottonlands","Cowies Hill":"Cowies Hill","Cowies Hill Park":"Cowies Hill Park","Crestholme":"Crestholme","Crestview":"Crestview","Croftdene":"Croftdene","Crossmoor":"Crossmoor","Dalbridge":"Dalbridge","Dawncliffe":"Dawncliffe","Dawncrest Verulam":"Dawncrest Verulam","Dawncrest Westville":"Dawncrest Westville","Delefarm":"Delefarm","Desainager":"Desainager","Dessenhoek":"Dessenhoek","Doon Heights":"Doon Heights","Doonside":"Doonside","Dores Flats":"Dores Flats","Drummond":"Drummond","Duffs Road":"Duffs Road","Durban Central":"Durban Central","Durban North":"Durban North","Earlsfield":"Earlsfield","Eastbury":"Eastbury","Effingham":"Effingham","Ekuthuleni":"Ekuthuleni","Emakhosini":"Emakhosini","Emansenseni":"Emansenseni","Emawothi":"Emawothi","Emgidweni":"Emgidweni","Emlandweni":"Emlandweni","Emlanjeni":"Emlanjeni","Emmaus":"Emmaus","Emthini":"Emthini","Enkanyisweni":"Enkanyisweni","Epitoli":"Epitoli","Escombe":"Escombe","Essenwood":"Essenwood","Everest Heights":"Everest Heights","Everton":"Everton","Everton Hillcrest":"Everton Hillcrest","Extension":"Extension","Ezikhalini":"Ezikhalini","Ezilwaneni":"Ezilwaneni","Ezimbokodweni":"Ezimbokodweni","Ezinyonini":"Ezinyonini","Fairbreeze":"Fairbreeze","Falcon Industrial Park":"Falcon Industrial Park","Farningham Ridge":"Farningham Ridge","Fields Hills":"Fields Hills","Flamingo Heights":"Flamingo Heights","Flanders":"Flanders","Forest Hills":"Forest Hills","Foresthaven":"Foresthaven","Fynnland":"Fynnland","Gandhi\'s Hill":"Gandhi\'s Hill","Genazano":"Genazano","Ghandinagar":"Ghandinagar","Gillits":"Gillits","Glen Anil":"Glen Anil","Glen Hills":"Glen Hills","Glen Park":"Glen Park","Glenashley":"Glenashley","Glenmore":"Glenmore","Glenwood":"Glenwood","Graeross Estate":"Graeross Estate","Grangetown":"Grangetown","Grayleigh":"Grayleigh","Greenbury":"Greenbury","Greenwood Park":"Greenwood Park","Greyville":"Greyville","Grosvenor":"Grosvenor","Grove End":"Grove End","Hagart Road Industrial":"Hagart Road Industrial","Hambanati Village":"Hambanati Village","Hammarstale":"Hammarstale","Hammersdale":"Hammersdale","Hatton Estate":"Hatton Estate","Havenside":"Havenside","Herrwood Park":"Herrwood Park","Highland Hills":"Highland Hills","Hildene":"Hildene","Hillary":"Hillary","Hillcrest":"Hillcrest","Hillcrest Park":"Hillcrest Park","Hillgrove":"Hillgrove","Hillhead":"Hillhead","Hippo Road":"Hippo Road","Illovo Beach":"Illovo Beach","Illovo Glen":"Illovo Glen","Inanda":"Inanda","Inanda New Town":"Inanda New Town","Inyaninga":"Inyaninga","Isipingo Beach":"Isipingo Beach","Isipingo Hills":"Isipingo Hills","Isipingo Rail":"Isipingo Rail","Island View":"Island View","Izinga Ridge":"Izinga Ridge","Jacobs":"Jacobs","Karradene":"Karradene","Kenville":"Kenville","Kharwastan":"Kharwastan","Kingsburgh":"Kingsburgh","Kingsmead":"Kingsmead","Klaarwater":"Klaarwater","Kloof":"Kloof","Kloof Falls":"Kloof Falls","Kwa Makhutha":"Kwa Makhutha","Kwadabeka":"Kwadabeka","Kwalinda":"Kwalinda","Kwamashu":"Kwamashu","Kwandengezi":"Kwandengezi","Kwandengezi Informal":"Kwandengezi Informal","La Lucia":"La Lucia","La Mercy":"La Mercy","Lagoon":"Lagoon","Lamontville":"Lamontville","Lange Fontein":"Lange Fontein","Lenham":"Lenham","Lindley":"Lindley","Litchie Farm":"Litchie Farm","Longcroft":"Longcroft","Lotus Park":"Lotus Park","Lotusville":"Lotusville","Luganda (Soni\'s Farm)":"Luganda (Soni\'s Farm)","Mahogany Ridge":"Mahogany Ridge","Maidstone":"Maidstone","Malaba Hills":"Malaba Hills","Malagazi":"Malagazi","Malvern":"Malvern","Manors":"Manors","Marianhill":"Marianhill","Marianhill Park":"Marianhill Park","Mariann Industrial Park":"Mariann Industrial Park","Mariannheights":"Mariannheights","Mariannridge":"Mariannridge","Mawelewele":"Mawelewele","Maxmead":"Maxmead","Maydon Wharf":"Maydon Wharf","Mayville":"Mayville","Mazakhele":"Mazakhele","Memorial Park":"Memorial Park","Merebank East":"Merebank East","Merebank West":"Merebank West","Merewent":"Merewent","Missionlands Industrial Park":"Missionlands Industrial Park","Mitchell Village":"Mitchell Village","Mithanagar":"Mithanagar","Mobeni East":"Mobeni East","Mobeni Heights":"Mobeni Heights","Mobeni West":"Mobeni West","Molweni":"Molweni","Montclair":"Montclair","Montefeel":"Montefeel","Montford":"Montford","Moorton":"Moorton","Morningside":"Morningside","Moseley":"Moseley","Moseley Park":"Moseley Park","Motala Heights":"Motala Heights","Motalabad":"Motalabad","Mount Edgecombe":"Mount Edgecombe","Mount Edgecombe Cntry Estate 1":"Mount Edgecombe Cntry Estate 1","Mount Edgecombe Cntry Estate 2":"Mount Edgecombe Cntry Estate 2","Mount Moreland":"Mount Moreland","Mount Moriah":"Mount Moriah","Mount Vernon":"Mount Vernon","Mountain Ridge":"Mountain Ridge","Mountview":"Mountview","Mpola":"Mpola","Musgrave":"Musgrave","Nagina":"Nagina","Nazareth":"Nazareth","New Dawn Park":"New Dawn Park","New Germany":"New Germany","Newlands East":"Newlands East","Newlands West":"Newlands West","Newsel Beach":"Newsel Beach","Newtown Inanda":"Newtown Inanda","Newtown Tongaat":"Newtown Tongaat","Nirvana Hills":"Nirvana Hills","Nkandla":"Nkandla","North Beach":"North Beach","North Industria":"North Industria","Northcroft":"Northcroft","Northdene":"Northdene","Northway":"Northway","Nsiswakazi":"Nsiswakazi","Ntuzuma":"Ntuzuma","Oakford Priory":"Oakford Priory","Oaklands Inner West":"Oaklands Inner West","Oaklands Verulam":"Oaklands Verulam","Ocean View":"Ocean View","Orient Hill":"Orient Hill","Ottawa":"Ottawa","Outer West Durban":"Outer West Durban","Overport":"Overport","Padfield Park":"Padfield Park","Palmers Estate":"Palmers Estate","Palmiet":"Palmiet","Palmview":"Palmview","Panare":"Panare","Panorama Park":"Panorama Park","Paradise Valley":"Paradise Valley","Park Hill":"Park Hill","Parkgate":"Parkgate","Parlock":"Parlock","Peter Road":"Peter Road","Phoenix":"Phoenix","Phoenix Industrial":"Phoenix Industrial","Phumphele Link Area":"Phumphele Link Area","Pinelands":"Pinelands","Pineside":"Pineside","Pinetown":"Pinetown","Pineview":"Pineview","Point":"Point","Prestondale":"Prestondale","Prospect Hall":"Prospect Hall","Prospecton":"Prospecton","Quarry Heights":"Quarry Heights","Queensburgh":"Queensburgh","Queensmead Industrial":"Queensmead Industrial","Rainham":"Rainham","Recreation":"Recreation","Red Hill":"Red Hill","Redcliffe":"Redcliffe","Redfern":"Redfern","Regency Park":"Regency Park","Reservoir Hills":"Reservoir Hills","Reunion":"Reunion","Ridgeview":"Ridgeview","Riet River":"Riet River","Risecliff":"Risecliff","Riverhorse Valley":"Riverhorse Valley","Riverside":"Riverside","Riverview Park":"Riverview Park","Riyadh":"Riyadh","Rockford":"Rockford","Ronaldskloof":"Ronaldskloof","Rossburgh":"Rossburgh","Rydalvale":"Rydalvale","Saana Township":"Saana Township","Sandfields":"Sandfields","Sarnia":"Sarnia","Savanna Park":"Savanna Park","Sea Cow Lake":"Sea Cow Lake","Sea View":"Sea View","Selection Beach":"Selection Beach","Shaka\'s Rock":"Shaka\'s Rock","Shallcross":"Shallcross","Shastri Park":"Shastri Park","Shembes Village":"Shembes Village","Sherwood":"Sherwood","Shortlands":"Shortlands","Shulton Park":"Shulton Park","Silstone":"Silstone","Silver Glen":"Silver Glen","Somerset Park":"Somerset Park","Soni\'s Farm (Luganda)":"Soni\'s Farm (Luganda)","South Beach":"South Beach","Southamptonpark":"Southamptonpark","Southcliff":"Southcliff","Southgate":"Southgate","Southmead":"Southmead","Southridge":"Southridge","Sparks":"Sparks","Springfield":"Springfield","St. Helier":"St. Helier","St. Wendolins Ridge":"St. Wendolins Ridge","St. Winifreds":"St. Winifreds","Stamford Hill":"Stamford Hill","Stanmore":"Stanmore","Starwood":"Starwood","Steelcastle":"Steelcastle","Sthundu Hill":"Sthundu Hill","Stockville Valley":"Stockville Valley","Stonebridge":"Stonebridge","Summerveld":"Summerveld","Sunford":"Sunford","Sunningdale":"Sunningdale","Surprise Farm":"Surprise Farm","Sydenham":"Sydenham","Temple Valley":"Temple Valley","The Wolds":"The Wolds","Thorn Glen":"Thorn Glen","Thornwood":"Thornwood","Tollgate  South":"Tollgate  South","Tongaat":"Tongaat","Tongaat Beach":"Tongaat Beach","Treasure Beach":"Treasure Beach","Trenance Manor":"Trenance Manor","Trenance Park":"Trenance Park","Trurolands":"Trurolands","Tshelimnyama":"Tshelimnyama","Umbedula":"Umbedula","Umbilo":"Umbilo","Umbilo Industrial":"Umbilo Industrial","Umbogintwini":"Umbogintwini","Umbongintwini":"Umbongintwini","Umdloti":"Umdloti","Umdloti Beach":"Umdloti Beach","Umgababa":"Umgababa","Umgeni Business Park":"Umgeni Business Park","Umhlanga":"Umhlanga","Umhlanga Crest":"Umhlanga Crest","Umhlanga L.A.":"Umhlanga L.A.","Umhlanga Manors":"Umhlanga Manors","Umhlanga Ridge":"Umhlanga Ridge","Umhlanga Rocks":"Umhlanga Rocks","Umhlangane":"Umhlangane","Umhlatuzana":"Umhlatuzana","Umhlatuzana Valley":"Umhlatuzana Valley","Umhloti Heights":"Umhloti Heights","Umkumbaan":"Umkumbaan","Umlazi":"Umlazi","Umlazi Glebe":"Umlazi Glebe","Umshinini":"Umshinini","Unit 1":"Unit 1","Unit 10":"Unit 10","Unit 11":"Unit 11","Unit 12":"Unit 12","Unit 13":"Unit 13","Unit 14":"Unit 14","Unit 15":"Unit 15","Unit 16":"Unit 16","Unit 17":"Unit 17","Unit 18":"Unit 18","Unit 19":"Unit 19","Unit 2":"Unit 2","Unit 21":"Unit 21","Unit 22":"Unit 22","Unit 23":"Unit 23","Unit 24":"Unit 24","Unit 3":"Unit 3","Unit 5":"Unit 5","Unit 6":"Unit 6","Unit 7":"Unit 7","Unit 8":"Unit 8","Unit 9":"Unit 9","University":"University","Valdin Heights":"Valdin Heights","Van Riebeeck Park":"Van Riebeeck Park","Vanrova":"Vanrova","Verulam":"Verulam","Verulem":"Verulem","Virginia":"Virginia","Warner Beach":"Warner Beach","Washington Heights":"Washington Heights","Waterfall":"Waterfall","Waterloo":"Waterloo","Waterways":"Waterways","Watsonia":"Watsonia","Welbedatch":"Welbedatch","Wentworth":"Wentworth","West Riding":"West Riding","Westbrook N":"Westbrook N","Westbrook S":"Westbrook S","Westcliff":"Westcliff","Westham":"Westham","Westmead":"Westmead","Westridge":"Westridge","Westville":"Westville","Whetstone":"Whetstone","Wiggins":"Wiggins","Windermere":"Windermere","Windston Park":"Windston Park","Winkelspruit":"Winkelspruit","Winston Park":"Winston Park","Woodhurst":"Woodhurst","Woodlands":"Woodlands","Woodlands Gillitts":"Woodlands Gillitts","Woodlands Mobeni":"Woodlands Mobeni","Woodlands North":"Woodlands North","Woodside":"Woodside","Woodview":"Woodview","Wyebank":"Wyebank","Yellow Wood Park":"Yellow Wood Park","Zilweni":"Zilweni","Zimbali":"Zimbali","Zwolle Estate":"Zwolle Estate"}},"Durnacol":{"items":{"CBD":"CBD"}},"Duynefontein":{"items":{"CBD":"CBD"}},"Dwaalboom":{"items":{"CBD":"CBD"}},"Dwarskersbos":{"items":{"CBD":"CBD"}},"Dysseldorp":{"items":{"CBD":"CBD"}},"Dzanani":{"items":{"CBD":"CBD"}},"East Driefonten":{"items":{"CBD":"CBD"}},"East London":{"items":{"Abbotsford":"Abbotsford","Amalinda":"Amalinda","Arcadia":"Arcadia","Baysville":"Baysville","Beacon Bay":"Beacon Bay","Belgravia":"Belgravia","Berea":"Berea","Bonnie Doon":"Bonnie Doon","Bonza bay":"Bonza bay","Braelyn":"Braelyn","Bunkers Hill":"Bunkers Hill","Cambridge":"Cambridge","CBD":"CBD","Chiselhurst":"Chiselhurst","Collondale":"Collondale","Dawn":"Dawn","Dorchester Heights":"Dorchester Heights","Dunoon":"Dunoon","Eastward Ho":"Eastward Ho","Eureka":"Eureka","Gately":"Gately","Gompo":"Gompo","Gonubi":"Gonubi","Gonubie":"Gonubie","Greenfields":"Greenfields","Haven Hills":"Haven Hills","High Gate":"High Gate","Kwelera":"Kwelera","Nahoon":"Nahoon","Nahoon Valley":"Nahoon Valley","North End":"North End","Ocean View":"Ocean View","Orange Grove":"Orange Grove","Panmure":"Panmure","Quigney":"Quigney","Rosemount":"Rosemount","Selbourne":"Selbourne","Southernwood":"Southernwood","Stirling":"Stirling","Sunnyridge":"Sunnyridge","Sunrise-On-Sea":"Sunrise-On-Sea","Union Arcade":"Union Arcade","Vincent":"Vincent","West Bank":"West Bank","Willow Park":"Willow Park","Wilsonia":"Wilsonia","Winterstrand":"Winterstrand","Woodbrook":"Woodbrook"}},"East London - Townships":{"items":{"Buffalo Flats":"Buffalo Flats","CBD":"CBD","Duncan Village":"Duncan Village","Mdantsane":"Mdantsane","Nompumelelo":"Nompumelelo","Parkside":"Parkside","Peffervile":"Peffervile"}},"Edenburg":{"items":{"CBD":"CBD"}},"Edenville":{"items":{"CBD":"CBD"}},"EENDEKUIL":{"items":{"CBD":"CBD"}},"Eeram Station":{"items":{"CBD":"CBD"}},"Eersterivier":{"items":{"CBD":"CBD"}},"Eersterivierstrand":{"items":{"CBD":"CBD"}},"Ekandustria":{"items":{"CBD":"CBD"}},"Ekangala":{"items":{"CBD":"CBD"}},"Elands Bay":{"items":{"CBD":"CBD"}},"Elandsdoorn":{"items":{"CBD":"CBD"}},"Elandslaagte":{"items":{"CBD":"CBD"}},"Elgin":{"items":{"CBD":"CBD"}},"Elim, Limpopo":{"items":{"CBD":"CBD"}},"Elim, Western Cape":{"items":{"CBD":"CBD"}},"Elliot":{"items":{"CBD":"CBD"}},"Elliotdale":{"items":{"CBD":"CBD"}},"Elukwatini":{"items":{"CBD":"CBD"}},"Elysium":{"items":{"CBD":"CBD"}},"EMangweni":{"items":{"CBD":"CBD"}},"Embalenhle":{"items":{"CBD":"CBD"}},"Embekweni":{"items":{"CBD":"CBD"}},"eMondlo":{"items":{"CBD":"CBD"}},"Empangeni":{"items":{"CBD":"CBD","Fairview":"Fairview","Ngwelezane":"Ngwelezane","Richem":"Richem"}},"Empuluzi":{"items":{"CBD":"CBD"}},"Emzinoni":{"items":{"CBD":"CBD"}},"Engcobo":{"items":{"CBD":"CBD"}},"Ermelo":{"items":{"CBD":"CBD"}},"Eshowe":{"items":{"CBD":"CBD"}},"Esikhawini":{"items":{"CBD":"CBD"}},"Estcourt":{"items":{"CBD":"CBD"}},"Eston":{"items":{"CBD":"CBD"}},"Evander":{"items":{"CBD":"CBD"}},"Evaton":{"items":{"CBD":"CBD"}},"Excelsior":{"items":{"CBD":"CBD"}},"Ezakheni":{"items":{"CBD":"CBD"}},"Fauresmith":{"items":{"CBD":"CBD"}},"Felixton":{"items":{"CBD":"CBD"}},"Fernie":{"items":{"CBD":"CBD"}},"Ficksburg":{"items":{"CBD":"CBD"}},"Fisantekraal":{"items":{"CBD":"CBD"}},"Fish River":{"items":{"CBD":"CBD"}},"Fisherhaven":{"items":{"CBD":"CBD"}},"Flagstaff":{"items":{"CBD":"CBD"}},"Fochville":{"items":{"CBD":"CBD"}},"Fort Beaufort":{"items":{"CBD":"CBD"}},"Fort Jackson":{"items":{"CBD":"CBD"}},"Fouriesburg":{"items":{"CBD":"CBD"}},"Frankfort":{"items":{"CBD":"CBD"}},"Franklin":{"items":{"CBD":"CBD"}},"Franschoek":{"items":{"CBD":"CBD"}},"Franskraal":{"items":{"CBD":"CBD"}},"Fraserburg":{"items":{"CBD":"CBD"}},"Ga-Marishane":{"items":{"CBD":"CBD"}},"Ga-Masemola":{"items":{"CBD":"CBD"}},"Ga-Mathabatha":{"items":{"CBD":"CBD"}},"Ga-Mathako":{"items":{"CBD":"CBD"}},"Ga-Mokgwathi":{"items":{"CBD":"CBD"}},"Ga-Montshonyana":{"items":{"CBD":"CBD"}},"Ga-Monyeki":{"items":{"CBD":"CBD"}},"Ga-Mothiba":{"items":{"CBD":"CBD"}},"Ga-Motle":{"items":{"CBD":"CBD"}},"Ga-Phaahla":{"items":{"CBD":"CBD"}},"Ga-Rankuwa":{"items":{"CBD":"CBD"}},"Ga-Rantlapane":{"items":{"CBD":"CBD"}},"Gamalake":{"items":{"CBD":"CBD"}},"Gamatlala":{"items":{"CBD":"CBD"}},"Gamtoos":{"items":{"CBD":"CBD"}},"Gansbaai":{"items":{"CBD":"CBD"}},"Ganyesa":{"items":{"CBD":"CBD"}},"Gariepdam":{"items":null},"Garies":{"items":null},"Gelukspan":{"items":null},"Gemsbokvlakte":{"items":null},"Genadendal":{"items":null},"George":{"items":null},"Gerdau":{"items":null},"Gingindlovu":{"items":null},"Giyani":{"items":null},"Glen":{"items":null},"Glen Cowie":{"items":null},"Glen Gariff":{"items":{"CBD":"CBD"}},"Glencoe":{"items":{"CBD":"CBD"}},"Glenharvie":{"items":{"CBD":"CBD"}},"Glenmore Beach":{"items":{"CBD":"CBD"}},"Glentana":{"items":{"CBD":"CBD"}},"Glenthorpe":{"items":{"CBD":"CBD"}},"Goedemoed":{"items":{"CBD":"CBD"}},"Golden Valley":{"items":{"CBD":"CBD"}},"Golela":{"items":{"CBD":"CBD"}},"Gomolo":{"items":{"CBD":"CBD"}},"Gonubie":{"items":{"CBD":"CBD"}},"Goodwood - NW":{"items":{"CBD":"CBD"}},"Gopane":{"items":{"CBD":"CBD"}},"Gordons Bay":{"items":{"Gordon\'s Bay Central":"Gordon\'s Bay Central"}},"Gouda":{"items":{"CBD":"CBD"}},"Gouritsmond":{"items":{"CBD":"CBD"}},"Graaff-Reinet":{"items":{"Adendorp":"Adendorp","CBD":"CBD"}},"Graafwater":{"items":{"CBD":"CBD"}},"Grabouw":{"items":{"CBD":"CBD"}},"Grahamstown":{"items":{"CBD":"CBD"}},"Graskop":{"items":{"CBD":"CBD"}},"Gravelotte":{"items":{"CBD":"CBD"}},"Greylingstad":{"items":{"CBD":"CBD"}},"Greyton":{"items":{"CBD":"CBD"}},"Greytown":{"items":{"CBD":"CBD"}},"Griekwastad":{"items":{"CBD":"CBD"}},"Groblersbrug":{"items":{"CBD":"CBD"}},"Groblersdal":{"items":{"CBD":"CBD"}},"Groblershoop":{"items":{"CBD":"CBD"}},"Groot Brak Rivier":{"items":{"CBD":"CBD"}},"Groot Marico":{"items":{"CBD":"CBD"}},"Groot-Jongensfontein":{"items":{"CBD":"CBD"}},"Grootdrink":{"items":{"CBD":"CBD"}},"Grootvlei":{"items":{"CBD":"CBD"}},"Grotto Bay":{"items":{"CBD":"CBD"}},"Groutville":{"items":{"CBD":"CBD"}},"Grovedale Farm":{"items":{"CBD":"CBD"}},"Gugulethu":{"items":{"CBD":"CBD"}},"Guguletu":{"items":{"CBD":"CBD"}},"Haakdoornbult":{"items":{"CBD":"CBD"}},"Haarlem":{"items":{"CBD":"CBD"}},"Haenertsburg":{"items":{"CBD":"CBD"}},"Haga Haga":{"items":{"CBD":"CBD"}},"Halfgewonnen":{"items":{"CBD":"CBD"}},"Hamburg":{"items":{"CBD":"CBD"}},"Hammanskraal":{"items":{"Babelegi":"Babelegi","CBD":"CBD"}},"Hammersdale - Sterkspruit":{"items":{"CBD":"CBD"}},"Hankey":{"items":{"CBD":"CBD"}},"Hanover":{"items":{"CBD":"CBD"}},"Happy Valley":{"items":{"CBD":"CBD"}},"Harburg":{"items":{"CBD":"CBD"}},"Harding":{"items":{"CBD":"CBD"}},"Harkerville":{"items":{"CBD":"CBD"}},"Harrismith":{"items":{"CBD":"CBD"}},"Hartbeesfontein":{"items":{"CBD":"CBD"}},"Hartbeespoort":{"items":{"Broederstroom":"Broederstroom","CBD":"CBD","Ifafi":"Ifafi","Kosmos":"Kosmos","Meerhof":"Meerhof","Melodie":"Melodie","Pecanwood":"Pecanwood","Schoemansville":"Schoemansville","Syferfontein":"Syferfontein"}},"Hartebeesthoek RAO":{"items":{"CBD":"CBD"}},"Hartenbos":{"items":{"CBD":"CBD"}},"Hartswater":{"items":{"CBD":"CBD"}},"Hattingspruit":{"items":{"CBD":"CBD"}},"Hawston":{"items":{"CBD":"CBD"}},"Hazyview":{"items":{"CBD":"CBD"}},"Hebron":{"items":{"CBD":"CBD"}},"Hectorspruit":{"items":{"CBD":"CBD"}},"Heidelberg - Gauteng":{"items":{"Bergsig":"Bergsig","CBD":"CBD","Ratanda":"Ratanda","Rensburg":"Rensburg"}},"Heidelberg - WC":{"items":{"CBD":"CBD"}},"Heilbron":{"items":{"CBD":"CBD"}},"Hekpoort":{"items":{"CBD":"CBD"}},"Helpmekaar":{"items":null},"Hendrina":{"items":{"CBD":"CBD"}},"Henley on Klip":{"items":{"CBD":"CBD"}},"Hennenman":{"items":{"CBD":"CBD"}},"Herbertsdale":{"items":{"CBD":"CBD"}},"Hermanus":{"items":{"CBD":"CBD","Eastcliff":"Eastcliff"}},"Hermon":{"items":{"CBD":"CBD"}},"Herolds Bay":{"items":{"CBD":"CBD"}},"Herschel":{"items":{"CBD":"CBD"}},"Hertzogville":{"items":{"CBD":"CBD"}},"Hibberdene":{"items":{"CBD":"CBD"}},"Highflats":{"items":{"CBD":"CBD"}},"Hilton":{"items":{"CBD":"CBD","Leonard":"Leonard","Winterskloof":"Winterskloof"}},"Himeville":{"items":{"CBD":"CBD"}},"Hlabisa":{"items":{"CBD":"CBD"}},"Hluhluwe":{"items":{"CBD":"CBD"}},"Hobhouse":{"items":null},"Hoedspruit":{"items":null},"Hoekwil":{"items":null},"Hofmeyer":{"items":null},"Hogsback":{"items":null},"Hollandsdrift":{"items":null},"Hoopstad":{"items":null},"Hopefield":{"items":null},"Hopetown":{"items":null},"Hotagterklip":{"items":null},"Hotazel":{"items":null},"Howick":{"items":null},"Humansdorp":{"items":null},"Idutywa":{"items":null},"Ifafa Beach":{"items":null},"Illovo Beach":{"items":null},"Impendle":{"items":null},"Inanda":{"items":null},"Inchanga":{"items":null},"Indwe":{"items":null},"Ingogo":{"items":null},"Ingwavuma":{"items":null},"Isithebe":{"items":null},"Itireleng":{"items":null},"Itsoseng":{"items":null},"Ixopo":{"items":null},"Izingolweni":{"items":null},"Jacobs Bay":{"items":null},"Jacobsdal":{"items":null},"Jagersfontein":{"items":{"CBD":"CBD"}},"Jagersrust":{"items":{"CBD":"CBD"}},"Jamestown":{"items":{"CBD":"CBD"}},"Jan Kempdorp":{"items":{"CBD":"CBD"}},"Jane Furse":{"items":{"CBD":"CBD"}},"Jansenville":{"items":{"CBD":"CBD"}},"Jeffreys Bay":{"items":{"CBD":"CBD","Wavecrest":"Wavecrest"}},"Jeppes Reef":{"items":{"CBD":"CBD"}},"Joe Slovo Park":{"items":{"CBD":"CBD"}},"Johannesburg":{"items":{"A.P. Khumalo":"A.P. Khumalo","Aanwins A.H.":"Aanwins A.H.","Abbotsford":"Abbotsford","Abmarie":"Abmarie","Activia Park":"Activia Park","Actonville":"Actonville","Admin Block":"Admin Block","Aeroton":"Aeroton","Aerovaal":"Aerovaal","Agavia":"Agavia","Airdin A.H.":"Airdin A.H.","AIRDLIN A.H.":"AIRDLIN A.H.","Airfield":"Airfield","Airport Park":"Airport Park","Alan Manor":"Alan Manor","Albemarle":"Albemarle","Alberante":"Alberante","Alberton":"Alberton","Albertsdal":"Albertsdal","Albertskroon":"Albertskroon","Albertville":"Albertville","Aldara Park":"Aldara Park","Aldarapark":"Aldarapark","Alewynspoort":"Alewynspoort","Alexandra":"Alexandra","Allandale":"Allandale","Allandale Park":"Allandale Park","Allen Grove":"Allen Grove","Allens Nek":"Allens Nek","Alphen Park":"Alphen Park","Alrapark":"Alrapark","Alrode":"Alrode","Alrode South":"Alrode South","Alsef A.H.":"Alsef A.H.","Althea Park A.H.":"Althea Park A.H.","Alveda":"Alveda","Amalgam":"Amalgam","Ambot A.H.":"Ambot A.H.","Amorosa":"Amorosa","Anchorville":"Anchorville","Anderbolt":"Anderbolt","Antwerp":"Antwerp","Anzac":"Anzac","Apex":"Apex","Apple Park":"Apple Park","Arcon Park":"Arcon Park","Armadale":"Armadale","Ashanti":"Ashanti","Aspen Hills":"Aspen Hills","Aspen Lakes":"Aspen Lakes","Aston Manor":"Aston Manor","Atholhurst":"Atholhurst","Atholl":"Atholl","Atholl Gardens":"Atholl Gardens","Atlas":"Atlas","Atlasville":"Atlasville","Auckland Park":"Auckland Park","Aureus":"Aureus","Austin View":"Austin View","Austin View A.h.":"Austin View A.h.","Aveleda Park":"Aveleda Park","Azaadville":"Azaadville","Bagleyston":"Bagleyston","Bakerton":"Bakerton","Ballindean A.H.":"Ballindean A.H.","Balmoral Estates":"Balmoral Estates","Bambayi":"Bambayi","Banlett":"Banlett","Baragwanath":"Baragwanath","Barbeque A.H.":"Barbeque A.H.","Barbeque Downs":"Barbeque Downs","Barbeque Downs Business Park":"Barbeque Downs Business Park","Bardene":"Bardene","Barlow Park":"Barlow Park","Barnasdal":"Barnasdal","Bartlett":"Bartlett","Barvallen":"Barvallen","Bassonia":"Bassonia","Bassonia Rock":"Bassonia Rock","Bazelo":"Bazelo","Beach Front":"Beach Front","Beaulieu":"Beaulieu","Bedford Gardens":"Bedford Gardens","Bedford Park":"Bedford Park","Bedfordview":"Bedfordview","Bedworth Park":"Bedworth Park","Belgravia":"Belgravia","Bellairspark":"Bellairspark","Bellavista Estate":"Bellavista Estate","Bellevue":"Bellevue","Bellevue Central":"Bellevue Central","Bellevue East":"Bellevue East","Benmore":"Benmore","Benmore Gardens":"Benmore Gardens","Benoni":"Benoni","Benoni A.H.":"Benoni A.H.","Benoni North A.H.":"Benoni North A.H.","Benoni Small Farms":"Benoni Small Farms","Benoni South":"Benoni South","Benrose":"Benrose","Berario":"Berario","Berea":"Berea","Bergbron":"Bergbron","Bergsig":"Bergsig","Berton Park":"Berton Park","Bertrams":"Bertrams","Besfontein A.H.":"Besfontein A.H.","Beverley":"Beverley","Beverley A.H.":"Beverley A.H.","Beverley AH":"Beverley AH","Beverley Gardens":"Beverley Gardens","Beverley Hill":"Beverley Hill","Beyers Park":"Beyers Park","Bezuidenhout Valley":"Bezuidenhout Valley","Bhongweni":"Bhongweni","Birch Acres":"Birch Acres","Birchleigh":"Birchleigh","Birchleigh A.H.":"Birchleigh A.H.","Birchleigh North":"Birchleigh North","Birdhaven":"Birdhaven","Birnam":"Birnam","Blackheath":"Blackheath","Blair Athol":"Blair Athol","Blairgowrie":"Blairgowrie","Blandford Ridge A.H.":"Blandford Ridge A.H.","Blignautsrus":"Blignautsrus","Bloubosrand":"Bloubosrand","Blue Gill":"Blue Gill","Blue Heaven":"Blue Heaven","Blue Hills":"Blue Hills","Blue Saddle Ranches":"Blue Saddle Ranches","Bluegum View":"Bluegum View","Boipatong":"Boipatong","Boksburg":"Boksburg","Boksburg East Industrial":"Boksburg East Industrial","Boksburg North":"Boksburg North","Boksburg South":"Boksburg South","Boksburg West":"Boksburg West","Boltonia":"Boltonia","Boltonworld":"Boltonworld","Bonaero Park":"Bonaero Park","Bonanne":"Bonanne","Bootha A.H.":"Bootha A.H.","Booysens":"Booysens","Booysens Reserve":"Booysens Reserve","Bophelong":"Bophelong","Bordeaux":"Bordeaux","Boskruin":"Boskruin","Bosmont":"Bosmont","Boswellville A.H.":"Boswellville A.H.","Bothasfontein":"Bothasfontein","Braamfontein":"Braamfontein","Braamfontein Werf":"Braamfontein Werf","Braampark":"Braampark","Brackendowns":"Brackendowns","Brackenhurst":"Brackenhurst","Brakpan":"Brakpan","Brakpan North":"Brakpan North","Bram Fischerville":"Bram Fischerville","Bramley":"Bramley","Bramley Gardens":"Bramley Gardens","Bramley Manor":"Bramley Manor","Bramley North":"Bramley North","Bramley Park":"Bramley Park","Bramley View":"Bramley View","Breaunanda":"Breaunanda","Brecknock A.H.":"Brecknock A.H.","Bredell A.H.":"Bredell A.H.","Brendavere A.H.":"Brendavere A.H.","Brenthurst":"Brenthurst","Brentwood":"Brentwood","Brentwood Park":"Brentwood Park","Brentwood Park A.H.":"Brentwood Park A.H.","Breswol A.H.":"Breswol A.H.","Bridle Park AH":"Bridle Park AH","Brixton":"Brixton","Broadacres":"Broadacres","BROADACRES AH":"BROADACRES AH","Bromhof":"Bromhof","Bronkhorstfontein":"Bronkhorstfontein","Bruma":"Bruma","Brushwood Haugh A.H.":"Brushwood Haugh A.H.","Bryanbrink":"Bryanbrink","Bryanpark":"Bryanpark","Bryanston":"Bryanston","Bryanston East":"Bryanston East","Bryanston West":"Bryanston West","Buccleuch":"Buccleuch","Burgersdorp":"Burgersdorp","Burgershoop":"Burgershoop","Burghersdorp":"Burghersdorp","Bush Hill A.H.":"Bush Hill A.H.","Bush Hill Estate":"Bush Hill Estate","Bushkoppies":"Bushkoppies","Buurendal":"Buurendal","Buyscelia":"Buyscelia","C.E. 2":"C.E. 2","C.E. 3":"C.E. 3","C.E. 4":"C.E. 4","C.E. 5":"C.E. 5","C.E. 6":"C.E. 6","C.W. 1":"C.W. 1","C.W. 2":"C.W. 2","C.W. 3":"C.W. 3","C.W. 4":"C.W. 4","C.W. 5":"C.W. 5","C.W. 6":"C.W. 6","C.W. 8":"C.W. 8","Carenvale":"Carenvale","Carlswald":"Carlswald","Carlswald A.H.":"Carlswald A.H.","CARLSWALD ESTATE":"CARLSWALD ESTATE","Caro Nome A.H.":"Caro Nome A.H.","Casey Park":"Casey Park","Cason":"Cason","Casseldale":"Casseldale","Castleview":"Castleview","Cedar Lakes":"Cedar Lakes","Central":"Central","Cerutville":"Cerutville","Chamdor":"Chamdor","Chancliff A.H.":"Chancliff A.H.","Chartwell A.H.":"Chartwell A.H.","Cheltondale":"Cheltondale","Chiawelo":"Chiawelo","Chislehurston":"Chislehurston","Chloorkop":"Chloorkop","Chris Hani":"Chris Hani","Chris Hani Park":"Chris Hani Park","Chrisville":"Chrisville","Cinderella":"Cinderella","City And Suburban":"City And Suburban","City Deep":"City Deep","City West":"City West","Claremont":"Claremont","Clarenspark":"Clarenspark","Clayville":"Clayville","Clayville East":"Clayville East","Clayville Industrial":"Clayville Industrial","Cleveden":"Cleveden","Cleveland":"Cleveland","Cloverdene":"Cloverdene","Clynton":"Clynton","Comet":"Comet","Commercia":"Commercia","Comptonville":"Comptonville","Constantia Kloof":"Constantia Kloof","Constantia Park":"Constantia Park","Corlett Gardens":"Corlett Gardens","Coronationville":"Coronationville","Cosmo City":"Cosmo City","Cottesloe":"Cottesloe","Country Life Park":"Country Life Park","Country View":"Country View","Cowdray Park":"Cowdray Park","Craigavon A.H.":"Craigavon A.H.","Craighall":"Craighall","Craighall Park":"Craighall Park","Cramerview":"Cramerview","Credi":"Credi","Cresslawn":"Cresslawn","Cresswell Park":"Cresswell Park","Cresta":"Cresta","Creston Hill":"Creston Hill","CRESWELL PARK":"CRESWELL PARK","Croesus":"Croesus","Crosby":"Crosby","Crown":"Crown","Crown City":"Crown City","Crown Gardens":"Crown Gardens","Crown Mines":"Crown Mines","Crown North":"Crown North","Crowthorne":"Crowthorne","Crowthorne A.h.":"Crowthorne A.h.","Croydon":"Croydon","Cruywagen Park":"Cruywagen Park","Crystal Gardens":"Crystal Gardens","Crystal Park":"Crystal Park","Culembeeck A.H.":"Culembeeck A.H.","Culemborg Park":"Culemborg Park","Cyrildene":"Cyrildene","Dadaville":"Dadaville","Daggafontein":"Daggafontein","Dainfern":"Dainfern","Dainfern Ridge":"Dainfern Ridge","Dal Fouche":"Dal Fouche","Dalecross":"Dalecross","Dalpark":"Dalpark","Dalview":"Dalview","Dan Pienaarville":"Dan Pienaarville","Daniapark":"Daniapark","Daniel Brink Park":"Daniel Brink Park","Daniel Brinkpark":"Daniel Brinkpark","Darrenwood":"Darrenwood","Daveyton":"Daveyton","Davidsonville":"Davidsonville","Dawn Park":"Dawn Park","Dawnview":"Dawnview","Dayanglen":"Dayanglen","De Deur":"De Deur","De Fontein":"De Fontein","De Klerkshof":"De Klerkshof","Debonair Park":"Debonair Park","Deeplevels":"Deeplevels","Delarey":"Delarey","Delmas":"Delmas","Delmore":"Delmore","Delmore Park":"Delmore Park","Delporton":"Delporton","Delville":"Delville","Deneysville":"Deneysville","Denlee":"Denlee","Dennehof":"Dennehof","Denneoord":"Denneoord","Denver":"Denver","Dersley":"Dersley","Devland":"Devland","Dewald Hattingh Park":"Dewald Hattingh Park","Dewetshof":"Dewetshof","Dewittsrus":"Dewittsrus","Dhlamini":"Dhlamini","Dickinsonville":"Dickinsonville","Diepkloof":"Diepkloof","Diepmeadow":"Diepmeadow","Diepsloot":"Diepsloot","Diepsloot West":"Diepsloot West","Dinwiddie":"Dinwiddie","Discovery":"Discovery","Diswilmar":"Diswilmar","Dobsonville":"Dobsonville","Dobsonville Gardens":"Dobsonville Gardens","Doornfontein":"Doornfontein","Doornkop":"Doornkop","Doornrandjie":"Doornrandjie","Douglasdale":"Douglasdale","Dowerglen":"Dowerglen","Drakeville":"Drakeville","Dreamland":"Dreamland","Drie Ziek":"Drie Ziek","Driehoek":"Driehoek","Drieziek":"Drieziek","Droste Park":"Droste Park","Drumblade":"Drumblade","Dube":"Dube","Duduza":"Duduza","Duncanville":"Duncanville","Dunhill":"Dunhill","Dunkeld":"Dunkeld","Dunkeld West":"Dunkeld West","Dunmadeley":"Dunmadeley","Dunnottar":"Dunnottar","Dunsevern":"Dunsevern","Dunswart":"Dunswart","Dunvegan":"Dunvegan","Duxberry":"Duxberry","Eagle Canyon Golf Estate":"Eagle Canyon Golf Estate","East Geduld":"East Geduld","East Town":"East Town","Eastcliff":"Eastcliff","Eastgate":"Eastgate","Eastleigh":"Eastleigh","Eastvale":"Eastvale","Ebenhaezer Park":"Ebenhaezer Park","Ebner On Vaal":"Ebner On Vaal","Ebony Park":"Ebony Park","Ecaleni":"Ecaleni","Edelweiss":"Edelweiss","Eden Glen":"Eden Glen","Eden Park":"Eden Park","Edenburg":"Edenburg","Edendale":"Edendale","Edenvale":"Edenvale","Edleen":"Edleen","Eendracht":"Eendracht","Ehlanzeni":"Ehlanzeni","Eikenhof":"Eikenhof","Eikepark":"Eikepark","Eland Kleinhoewes":"Eland Kleinhoewes","Elandsdrift":"Elandsdrift","Elandsfontein":"Elandsfontein","Elandsfontein Rail":"Elandsfontein Rail","Elandshaven":"Elandshaven","Elandspark":"Elandspark","Elandsvlei":"Elandsvlei","Elcedes":"Elcedes","Eldorado Estate":"Eldorado Estate","Eldorado Park":"Eldorado Park","Electron":"Electron","Elindinga":"Elindinga","Elladoone":"Elladoone","Ellis Park":"Ellis Park","Elmapark":"Elmapark","Elsburg":"Elsburg","Elsieshof":"Elsieshof","Elspark":"Elspark","Elton Hill":"Elton Hill","Emangweni":"Emangweni","Emdeni":"Emdeni","Emfihlweni":"Emfihlweni","Emgandagandeni":"Emgandagandeni","Emkatini":"Emkatini","Emmarentia":"Emmarentia","Emoyeni":"Emoyeni","Emyoni":"Emyoni","Endayini":"Endayini","Endicott":"Endicott","Endulweni":"Endulweni","Ennerdale":"Ennerdale","Ennerdale South":"Ennerdale South","Entshonalanga":"Entshonalanga","Epsom Downs":"Epsom Downs","Erand":"Erand","Erand A.h.":"Erand A.h.","Erand Gardens":"Erand Gardens","Esangweni":"Esangweni","Esiqongweni":"Esiqongweni","Esiziba":"Esiziba","Esselen Park":"Esselen Park","Essexwold":"Essexwold","Estera":"Estera","Esther Park":"Esther Park","Ethafeni":"Ethafeni","Etwatwa":"Etwatwa","Evans Park":"Evans Park","Evaton":"Evaton","Evaton North":"Evaton North","Evaton West":"Evaton West","Everleigh":"Everleigh","Factoria":"Factoria","Fairland":"Fairland","Fairleads":"Fairleads","Fairmount":"Fairmount","Fairmount Ridge":"Fairmount Ridge","Fairvale":"Fairvale","Fairview":"Fairview","Fairway":"Fairway","Fairwood":"Fairwood","Falcon Ridge":"Falcon Ridge","Far East Bank":"Far East Bank","Farm Olifantsvlei":"Farm Olifantsvlei","Farm Turffontein":"Farm Turffontein","Farmall A.H.":"Farmall A.H.","Farrar Park":"Farrar Park","Farrarmere":"Farrarmere","Featherbrooke Estate":"Featherbrooke Estate","Fellside":"Fellside","Ferndale":"Ferndale","Ferreiras Dorp":"Ferreiras Dorp","Finetown":"Finetown","Finsbury":"Finsbury","Fishers Hill":"Fishers Hill","Fleurhof":"Fleurhof","Flora Gardens":"Flora Gardens","Floracliffe":"Floracliffe","Florentia":"Florentia","Florida":"Florida","Florida Glen":"Florida Glen","Florida Hills":"Florida Hills","Florida Lake":"Florida Lake","Florida North":"Florida North","Florida Park":"Florida Park","Florida View":"Florida View","Fontainebleau":"Fontainebleau","Forbesdale":"Forbesdale","Fordsburg":"Fordsburg","Forest Hill":"Forest Hill","Forest Town":"Forest Town","Formain":"Formain","Founders Hill":"Founders Hill","Founders View":"Founders View","Four Eight Six Scheme":"Four Eight Six Scheme","Fourways":"Fourways","Fourways Gardens":"Fourways Gardens","Framton":"Framton","Framton Industrial":"Framton Industrial","Frankenwald":"Frankenwald","Franklin Roosevelt Park":"Franklin Roosevelt Park","Fred Clarke":"Fred Clarke","Freedom Charter Square":"Freedom Charter Square","Freedom Park":"Freedom Park","Freeway Park":"Freeway Park","Fulcrum":"Fulcrum","Gahlanso":"Gahlanso","Gallagher Estate":"Gallagher Estate","Gallo Manor":"Gallo Manor","Geduld":"Geduld","Geluksdal":"Geluksdal","General Alberts Park":"General Alberts Park","Georgetown":"Georgetown","Georginia":"Georginia","Gerdview":"Gerdview","Germiston":"Germiston","Gillview":"Gillview","Glen Atholl":"Glen Atholl","Glen Austin":"Glen Austin","Glen Austin A.H":"Glen Austin A.H","Glen Austin A.h.":"Glen Austin A.h.","Glen Dayson A.H.":"Glen Dayson A.H.","Glen Eagles":"Glen Eagles","Glen Erasmia":"Glen Erasmia","Glen Marais":"Glen Marais","Glen Nerine A.H.":"Glen Nerine A.H.","Glen Ridge":"Glen Ridge","Glenadrienne":"Glenadrienne","Glenanda":"Glenanda","Glenesk":"Glenesk","Glenferness A.H.":"Glenferness A.H.","Glenhazel":"Glenhazel","Glenifer":"Glenifer","Gleniffer":"Gleniffer","Glenkay":"Glenkay","Glensan":"Glensan","Glenvarloch":"Glenvarloch","Glenvista":"Glenvista","Goba":"Goba","Goedeburg":"Goedeburg","Gold Reef City":"Gold Reef City","Golden Harvest":"Golden Harvest","Golden Springs":"Golden Springs","Goldev":"Goldev","Golf Park":"Golf Park","Golf View A.H.":"Golf View A.H.","Gordon\'s View":"Gordon\'s View","Gosforth Park":"Gosforth Park","Goudrand":"Goudrand","Government Village B":"Government Village B","Government Village R":"Government Village R","Grand Central":"Grand Central","Grasmere":"Grasmere","Greengate":"Greengate","Greenside":"Greenside","Greenside East":"Greenside East","Greenstone Hill":"Greenstone Hill","Greenstone Park":"Greenstone Park","Gresswold":"Gresswold","Greymont":"Greymont","Groblerpark":"Groblerpark","Groeneweide":"Groeneweide","Grootvaly":"Grootvaly","Gugulethu":"Gugulethu","Haddon":"Haddon","Haedway Hill":"Haedway Hill","Halfway Gardens":"Halfway Gardens","Halfway House":"Halfway House","Halfway House Estate":"Halfway House Estate","Hallgate A.H.":"Hallgate A.H.","Hamberg":"Hamberg","Harmelia":"Harmelia","Harmoniesrus":"Harmoniesrus","Harry Gwala Camp":"Harry Gwala Camp","Harveston A.H.":"Harveston A.H.","Hawkins Estate":"Hawkins Estate","Haylon Hill":"Haylon Hill","Hazel Park":"Hazel Park","Hazeldene":"Hazeldene","Headway Hill":"Headway Hill","Hectorton":"Hectorton","Helderkruin":"Helderkruin","Helenas Rust":"Helenas Rust","Helikon Park":"Helikon Park","Henley On Klip":"Henley On Klip","Henville":"Henville","Heriotdale":"Heriotdale","Heuningklip":"Heuningklip","Highbury":"Highbury","Highland":"Highland","Highlands":"Highlands","Highlands North":"Highlands North","Highway Gardens":"Highway Gardens","Hill And Dales":"Hill And Dales","Hillbrow":"Hillbrow","Hillcrest A.H.":"Hillcrest A.H.","Hiltonia":"Hiltonia","Hlahatsi":"Hlahatsi","Hlongwane":"Hlongwane","Homelake":"Homelake","Homelands":"Homelands","Homer":"Homer","Homestead":"Homestead","Homestead Park":"Homestead Park","Honey Hill":"Honey Hill","Honeydew":"Honeydew","Honeydew Grove":"Honeydew Grove","Honeydew Manor":"Honeydew Manor","Honeydew Ridge":"Honeydew Ridge","Honeydew View":"Honeydew View","Honeypark":"Honeypark","Hoogland":"Hoogland","Hopefield":"Hopefield","Horison":"Horison","Horison Park":"Horison Park","Horison View":"Horison View","Horizon View":"Horizon View","Hospital Hill":"Hospital Hill","Hospital View":"Hospital View","Hostels":"Hostels","Houghton Estate":"Houghton Estate","Houtheuwel Indust.":"Houtheuwel Indust.","Houtkop":"Houtkop","Houtkoppen 193-Iq":"Houtkoppen 193-Iq","Hughes":"Hughes","Hunters Hill":"Hunters Hill","Huntingdon":"Huntingdon","Hurl Park":"Hurl Park","Hurlingham":"Hurlingham","Hurlingham Gardens":"Hurlingham Gardens","Hurlingham Manor":"Hurlingham Manor","Hurlyvale":"Hurlyvale","Hurst Hill":"Hurst Hill","Hwenele":"Hwenele","Hyde Park":"Hyde Park","Ibaxa":"Ibaxa","Ibazelo":"Ibazelo","Igqagqa":"Igqagqa","Ililiba":"Ililiba","Illiondale":"Illiondale","Illovo":"Illovo","Impala Park":"Impala Park","Inadan A.H.":"Inadan A.H.","Inanda":"Inanda","Industria":"Industria","Industria North":"Industria North","Industria West":"Industria West","Industries East":"Industries East","Industries West":"Industries West","Industry":"Industry","Informal Settlement":"Informal Settlement","Ingelthorpe A.H.":"Ingelthorpe A.H.","Innesfree":"Innesfree","Intokozo A.H.":"Intokozo A.H.","Inxiweni":"Inxiweni","Ironside A.H.":"Ironside A.H.","Ironsyde":"Ironsyde","Isando":"Isando","Isandovale":"Isandovale","Isekelo":"Isekelo","Isiphetweni":"Isiphetweni","Isithame":"Isithame","Isivana":"Isivana","Ivory Park":"Ivory Park","Jabavu":"Jabavu","Jabulani":"Jabulani","Jacanlee":"Jacanlee","Jan Hofmeyer":"Jan Hofmeyer","Jan Smuts Ville":"Jan Smuts Ville","Jansen Park":"Jansen Park","Japie Greyling Park":"Japie Greyling Park","Jatniel":"Jatniel","Jeppestown":"Jeppestown","Jeppestown South":"Jeppestown South","Jet Park":"Jet Park","Jiyana":"Jiyana","Johandeo":"Johandeo","Johannesburg":"Johannesburg","Johannesburg North":"Johannesburg North","Johnston Stop":"Johnston Stop","Jordaan Park":"Jordaan Park","Joubert Park":"Joubert Park","Judiths Paarl":"Judiths Paarl","Jukskei Park":"Jukskei Park","Jukskei View":"Jukskei View","Junction Hill":"Junction Hill","Jupiter":"Jupiter","Kaalfontein":"Kaalfontein","Kagiso":"Kagiso","Kamaland":"Kamaland","Kanana":"Kanana","Kapok":"Kapok","Katlehong":"Katlehong","Kelland":"Kelland","Kelly Ridge":"Kelly Ridge","Kelvin":"Kelvin","Kelvin View":"Kelvin View","Kempton Park":"Kempton Park","Kempton Park West":"Kempton Park West","Kengies":"Kengies","Kengies A.H.":"Kengies A.H.","Kenilworth":"Kenilworth","Kenleaf":"Kenleaf","Kenmare":"Kenmare","Kensington":"Kensington","Kensington B":"Kensington B","Kent View":"Kent View","Kew":"Kew","Khatamping":"Khatamping","Khyber Rock":"Khyber Rock","Kibler Park":"Kibler Park","Kildrummy A.H.":"Kildrummy A.H.","Kilfenora":"Kilfenora","Killarney":"Killarney","Kimbult A.H.":"Kimbult A.H.","Kleve Hill Park":"Kleve Hill Park","Klipfontein View":"Klipfontein View","Klipplaatdrift":"Klipplaatdrift","Klippoortje":"Klippoortje","Klippoortje A.L.":"Klippoortje A.L.","Klippoortjie":"Klippoortjie","Klipriver":"Klipriver","Klipriviersberg":"Klipriviersberg","Klipriviersberg Est":"Klipriviersberg Est","Klipriviersberg Estate A.H.":"Klipriviersberg Estate A.H.","Klipriviersberg Estate S.H.":"Klipriviersberg Estate S.H.","Klipriviersoog":"Klipriviersoog","Klipriviersoog Estate":"Klipriviersoog Estate","Klipspruit":"Klipspruit","Klipspruit West":"Klipspruit West","Kloofendal":"Kloofendal","Klopperpark":"Klopperpark","Knights":"Knights","Knopjeslaagte":"Knopjeslaagte","Knoxville":"Knoxville","Kocksoord":"Kocksoord","Kookfontein":"Kookfontein","Kookrus":"Kookrus","Kopanong":"Kopanong","Kramerville":"Kramerville","Krugersdorp":"Krugersdorp","Krugersdorp North":"Krugersdorp North","Krugersdorp West":"Krugersdorp West","Krugersrus":"Krugersrus","Kruinhof":"Kruinhof","Kwa-Thema":"Kwa-Thema","Kwa-Thema Central":"Kwa-Thema Central","Kya Sand":"Kya Sand","Kyalami":"Kyalami","Kyalami A.h.":"Kyalami A.h.","Kyalami Estate":"Kyalami Estate","Kyalami Gardens":"Kyalami Gardens","Kyalami Heights":"Kyalami Heights","Kyalami Hills":"Kyalami Hills","Kyalami Park":"Kyalami Park","La Rochelle":"La Rochelle","Labore":"Labore","Lake Deneys":"Lake Deneys","Lake View":"Lake View","Lake View Estate":"Lake View Estate","Lakefield":"Lakefield","Lakeside":"Lakeside","Lakeview":"Lakeview","Lambton":"Lambton","Lambton Gardens":"Lambton Gardens","Lancaster West":"Lancaster West","Langaville":"Langaville","Langlaagte":"Langlaagte","Langlaagte North":"Langlaagte North","Langrand":"Langrand","Lanseria":"Lanseria","Larrendale":"Larrendale","Laser Park":"Laser Park","Laserdowns Industrial Park":"Laserdowns Industrial Park","Lasiandra":"Lasiandra","Laversburg":"Laversburg","Lawley":"Lawley","Lawley Estate":"Lawley Estate","Lawley Resevoir":"Lawley Resevoir","Lea Glen":"Lea Glen","Leachville":"Leachville","Leaholm A.H.":"Leaholm A.H.","Leboeng":"Leboeng","Leeuhof":"Leeuhof","Leeukuil":"Leeukuil","Leeukuil Indust.":"Leeukuil Indust.","Lekaneng":"Lekaneng","Lenaron A.H.":"Lenaron A.H.","Lenasia":"Lenasia","Lenasia South":"Lenasia South","Lenteland":"Lenteland","Lenz":"Lenz","Leondale":"Leondale","Leratong Village":"Leratong Village","Lewisham":"Lewisham","Libradene":"Libradene","Liefde-en-Vrede":"Liefde-en-Vrede","Lifateng":"Lifateng","Likole":"Likole","Lilianton":"Lilianton","Lilyvale A.H.":"Lilyvale A.H.","Linbro Park":"Linbro Park","LINBRO PARK A.H.":"LINBRO PARK A.H.","Lindberg Park":"Lindberg Park","Lindbergh Park":"Lindbergh Park","Linden":"Linden","Lindhaven":"Lindhaven","Linkholm":"Linkholm","Linksfield":"Linksfield","Linksfield North":"Linksfield North","Linksfield Ridge":"Linksfield Ridge","Linksview":"Linksview","Linmeyer":"Linmeyer","Little Falls":"Little Falls","Littlefillan":"Littlefillan","Littlefillan A.H.":"Littlefillan A.H.","Lochvaal":"Lochvaal","Lodeyko":"Lodeyko","Lombardy East":"Lombardy East","Lombardy West":"Lombardy West","Lone Hill":"Lone Hill","Long Meadow Business Estate":"Long Meadow Business Estate","Longdale":"Longdale","Longmeadow Business Estate":"Longmeadow Business Estate","Lorentzville":"Lorentzville","Lougherin AH.":"Lougherin AH.","Louisrus":"Louisrus","Loumarina A.H.":"Loumarina A.H.","Lower Finsbury":"Lower Finsbury","Luipaardsvlei":"Luipaardsvlei","Lyme Park":"Lyme Park","Lyndhurst":"Lyndhurst","Mabuya Park":"Mabuya Park","Mackenzie Park":"Mackenzie Park","Mackenzieville":"Mackenzieville","Mafokeng":"Mafokeng","Magalies View":"Magalies View","Magaliessig":"Magaliessig","Makula":"Makula","Makulong":"Makulong","Malanshof":"Malanshof","Malvern":"Malvern","Malvern East":"Malvern East","Mandelaville":"Mandelaville","Mandeloview":"Mandeloview","Manterverede":"Manterverede","Manufacta":"Manufacta","Maokeng":"Maokeng","Mapetla":"Mapetla","Maphanga":"Maphanga","Mapleton A.H.":"Mapleton A.H.","Marais Steyn Park":"Marais Steyn Park","Maraisburg":"Maraisburg","Marise A.H.":"Marise A.H.","Marister A.H.":"Marister A.H.","Marlands":"Marlands","Marlboro":"Marlboro","Marlboro Gardens":"Marlboro Gardens","Marlboro North":"Marlboro North","Marlboro South":"Marlboro South","Maroeladal":"Maroeladal","Marshalltown":"Marshalltown","Martindale":"Martindale","Maryvale":"Maryvale","Maryvlei":"Maryvlei","Masetjhaba View":"Masetjhaba View","Mashimong":"Mashimong","Masimini":"Masimini","Matholesville":"Matholesville","Mavimbela":"Mavimbela","Mayabuye":"Mayabuye","Mayberry Park":"Mayberry Park","Mayfair":"Mayfair","Mayfair West":"Mayfair West","Mayfield Park":"Mayfield Park","Mckay":"Mckay","Meadowbrook":"Meadowbrook","Meadowdale":"Meadowdale","Meadowhurst":"Meadowhurst","Meadowlands":"Meadowlands","Meadowlands East":"Meadowlands East","Meadowlands West":"Meadowlands West","Megawatt Park":"Megawatt Park","Melrose":"Melrose","Melrose Arch":"Melrose Arch","Melrose Estate":"Melrose Estate","Melrose North":"Melrose North","Melville":"Melville","Meredale":"Meredale","Meydustria":"Meydustria","Meyersdal":"Meyersdal","Meyindustria":"Meyindustria","Micor":"Micor","Micor Ind":"Micor Ind","Mid-Ennerdale":"Mid-Ennerdale","Middelvlei A.H.":"Middelvlei A.H.","Midrand":"Midrand","Midridge Park":"Midridge Park","Migson Triangle":"Migson Triangle","Mill Hill":"Mill Hill","Millgate Farm A.H.":"Millgate Farm A.H.","Milpark":"Milpark","Mimosa Park":"Mimosa Park","Mindalore":"Mindalore","Minnebron":"Minnebron","Miravaal":"Miravaal","Mmesi Park":"Mmesi Park","Mngadi":"Mngadi","Modder East":"Modder East","Modderbee":"Modderbee","Modderfontein":"Modderfontein","Modderfontein A.H.":"Modderfontein A.H.","Moedi":"Moedi","Moffatview":"Moffatview","Mofolo":"Mofolo","Mofolo Central":"Mofolo Central","Mofolo North":"Mofolo North","Mofolo South":"Mofolo South","Mohlakeng":"Mohlakeng","Mokoena":"Mokoena","Molapo":"Molapo","Moleleki":"Moleleki","Moletsane":"Moletsane","Momentum Park":"Momentum Park","Monaheng":"Monaheng","Mondeor":"Mondeor","Monise":"Monise","Montclare":"Montclare","Montgomery Park":"Montgomery Park","Montroux":"Montroux","Monument":"Monument","Moodie Hill":"Moodie Hill","Mooilande":"Mooilande","Mopeli":"Mopeli","Morehill":"Morehill","Moret":"Moret","Morganridge":"Morganridge","Moriting":"Moriting","Morninghill":"Morninghill","Morningside":"Morningside","Morningside A.H.":"Morningside A.H.","Morningside Hills":"Morningside Hills","Morningside Manor":"Morningside Manor","Moroka":"Moroka","Moroka North West":"Moroka North West","Moseleke":"Moseleke","Moseleke East":"Moseleke East","Moshoeshoe":"Moshoeshoe","Mostyn Park A.H.":"Mostyn Park A.H.","Moteong":"Moteong","Motluong":"Motluong","Motsamai":"Motsamai","Motsoaledi":"Motsoaledi","Motsu":"Motsu","Mountain View Jhb":"Mountain View Jhb","Mpho":"Mpho","Mpilisweni":"Mpilisweni","Mqantsa":"Mqantsa","Mshenquville":"Mshenquville","Mthembu Village":"Mthembu Village","Mulbarton":"Mulbarton","Muldersdrift":"Muldersdrift","Munsieville":"Munsieville","Muswelldale":"Muswelldale","N.E. 3":"N.E. 3","N.E. 4":"N.E. 4","N.E. 5":"N.E. 5","N.W. 7":"N.W. 7","Nadustria":"Nadustria","Naledi":"Naledi","Nancefield":"Nancefield","Nancefield Industrial":"Nancefield Industrial","Nanescol":"Nanescol","Nasrec":"Nasrec","Naturena":"Naturena","Ncala":"Ncala","Ndhlazi":"Ndhlazi","Needwood":"Needwood","Nelsonia":"Nelsonia","Nestadt":"Nestadt","New Brighton":"New Brighton","New Centre":"New Centre","New Doornfontein":"New Doornfontein","New Era":"New Era","New Market Park":"New Market Park","New Modder":"New Modder","New Payneville":"New Payneville","New Redruth":"New Redruth","New State Areas":"New State Areas","Newclare":"Newclare","Newlands":"Newlands","Newmarket A.H.":"Newmarket A.H.","Newmarket Park":"Newmarket Park","Newtown":"Newtown","Ngema":"Ngema","Nhlapo":"Nhlapo","Nietgedacht":"Nietgedacht","Nimrod Park":"Nimrod Park","Nooderkrans":"Nooderkrans","Nooitgedacht":"Nooitgedacht","Noordekrans":"Noordekrans","Noordgesig":"Noordgesig","Noordhang":"Noordhang","Noordheuwel":"Noordheuwel","Noordloch":"Noordloch","Noordwyk":"Noordwyk","Norkem Park":"Norkem Park","Norscot":"Norscot","North Champagne Est":"North Champagne Est","North Doornfontein":"North Doornfontein","North Germiston":"North Germiston","North Riding":"North Riding","North Riding AH":"North Riding AH","Northcliff":"Northcliff","Northern Acres":"Northern Acres","Northgate":"Northgate","Northmead":"Northmead","Northvale":"Northvale","Northvilla":"Northvilla","Northwold":"Northwold","Norton Park":"Norton Park","Norton\'s Home Estate":"Norton\'s Home Estate","Norton\'s Home Estates":"Norton\'s Home Estates","Nortons Small Farms":"Nortons Small Farms","Norwood":"Norwood","Noycedale":"Noycedale","Nuffield":"Nuffield","Nywerheid":"Nywerheid","Oakdene":"Oakdene","Oaklands":"Oaklands","Oatlands":"Oatlands","Observatory":"Observatory","Oerder Park":"Oerder Park","Ohenimuri":"Ohenimuri","Old Cornelia Village":"Old Cornelia Village","Olievenhoutpoort":"Olievenhoutpoort","Olifantsfontein":"Olifantsfontein","Olifantsvlei Farm":"Olifantsvlei Farm","Olivanna":"Olivanna","Olivedale":"Olivedale","Ontdekkerspark":"Ontdekkerspark","Oospoort":"Oospoort","Ooster":"Ooster","Ophir":"Ophir","Ophirton":"Ophirton","Orange Farm":"Orange Farm","Orange Grove":"Orange Grove","Oranjehof":"Oranjehof","Orchards":"Orchards","Oriel":"Oriel","Orlando":"Orlando","Orlando East":"Orlando East","Orlando West":"Orlando West","Ormonde":"Ormonde","Ormonde View":"Ormonde View","Osummit":"Osummit","Overkruin":"Overkruin","Overline":"Overline","Paarlshoop":"Paarlshoop","Pageview":"Pageview","Palime":"Palime","Palm Ridge":"Palm Ridge","Palmlands":"Palmlands","Panorama":"Panorama","Panorama A.H.":"Panorama A.H.","Panorama Estates":"Panorama Estates","Park Central":"Park Central","Parkdene":"Parkdene","Parkhaven":"Parkhaven","Parkhill Gardens":"Parkhill Gardens","Parkhurst":"Parkhurst","Parkmore":"Parkmore","Parkrand":"Parkrand","Parktown":"Parktown","Parktown North":"Parktown North","Parkview":"Parkview","Parkwood":"Parkwood","Patlynn A.H.":"Patlynn A.H.","Paul Krugersoord":"Paul Krugersoord","Paulshof":"Paulshof","Paulshof A.H.":"Paulshof A.H.","Payneville":"Payneville","Peacehaven":"Peacehaven","Pendale":"Pendale","Pennyville":"Pennyville","Percelia Estate":"Percelia Estate","Persida":"Persida","Petersfield":"Petersfield","Petervale":"Petervale","Petit":"Petit","Phake":"Phake","Phase 1 Kwa-Thema":"Phase 1 Kwa-Thema","Phase 2 Kwa-Thema":"Phase 2 Kwa-Thema","Phelendaba":"Phelendaba","Phomolong":"Phomolong","Phooko":"Phooko","Phumulo":"Phumulo","Pierneef Park":"Pierneef Park","Pimville":"Pimville","Pimville Zone 1":"Pimville Zone 1","Pimville Zone 4":"Pimville Zone 4","Pimville Zone 5":"Pimville Zone 5","Pimville Zone 7":"Pimville Zone 7","Pine Park":"Pine Park","Pine Slopes":"Pine Slopes","Pinelands":"Pinelands","Pioneer":"Pioneer","Pirowville":"Pirowville","Plantation":"Plantation","Plooysville A.H.":"Plooysville A.H.","Pollak Park":"Pollak Park","Pomona":"Pomona","Pomona A.H.":"Pomona A.H.","Pongo Camp":"Pongo Camp","Poortjie":"Poortjie","Poortview":"Poortview","Poortview A.H.":"Poortview A.H.","Powa Park":"Powa Park","Power Park":"Power Park","Powerville":"Powerville","Praegville":"Praegville","President Park":"President Park","President Park A.H.":"President Park A.H.","President Ridge":"President Ridge","Presidents Ranch":"Presidents Ranch","Presidentsdam":"Presidentsdam","Pretoriusstad":"Pretoriusstad","Primrose":"Primrose","Primrose Hill":"Primrose Hill","Princess":"Princess","Princess A.H.":"Princess A.H.","Princess Informal Settlement":"Princess Informal Settlement","Prolecon":"Prolecon","Prosperita":"Prosperita","Protea Glen":"Protea Glen","Protea North":"Protea North","Protea Ridge":"Protea Ridge","Protea South":"Protea South","Putcoton":"Putcoton","Putfontein":"Putfontein","Putfontein A.H.":"Putfontein A.H.","Queenshaven":"Queenshaven","Quellerie Park":"Quellerie Park","Quellerina":"Quellerina","Rabie Ridge":"Rabie Ridge","Racecourse":"Racecourse","Raceview":"Raceview","Radebe":"Radebe","Radiokop":"Radiokop","Raedene":"Raedene","Raedene Estate":"Raedene Estate","Ramakonopi":"Ramakonopi","Ramakonopi East":"Ramakonopi East","Rand Collieries S.H.":"Rand Collieries S.H.","Rand Leases":"Rand Leases","Rand View":"Rand View","Randburg":"Randburg","Randgate":"Randgate","Randhart":"Randhart","Randjesfontein":"Randjesfontein","Randjespark":"Randjespark","Randpark":"Randpark","Randpark Ridge":"Randpark Ridge","Randparkrif":"Randparkrif","Randpoort":"Randpoort","Randvaal":"Randvaal","Randview":"Randview","Ranelagh":"Ranelagh","Rangeview":"Rangeview","Rangeview Camp":"Rangeview Camp","Rant-En-Dal":"Rant-En-Dal","Ratanda":"Ratanda","Raumaraispark":"Raumaraispark","Ravensklip":"Ravensklip","Ravenswood":"Ravenswood","Reefhaven":"Reefhaven","Refengkotso":"Refengkotso","Regency":"Regency","Regents Park":"Regents Park","Regents Park Estate":"Regents Park Estate","Reiger Park":"Reiger Park","Rembrandt Ridge":"Rembrandt Ridge","Rembrandtpark":"Rembrandtpark","Rensburg":"Rensburg","Rest In Peace":"Rest In Peace","Restonvale A.H.":"Restonvale A.H.","Reuven":"Reuven","Rewlatch":"Rewlatch","Reynolds View":"Reynolds View","Rhodesfield":"Rhodesfield","Richmond":"Richmond","Richmond Village":"Richmond Village","Ridgeway":"Ridgeway","Riepen Park":"Riepen Park","Rietfontein":"Rietfontein","Rietkol":"Rietkol","Rietvallei":"Rietvallei","RIETVLEI":"RIETVLEI","Risana":"Risana","Risi":"Risi","Risidale":"Risidale","Risiville":"Risiville","Rispark A.H.":"Rispark A.H.","River Park":"River Park","Riverbend A.H.":"Riverbend A.H.","Riverclub":"Riverclub","Riverglen":"Riverglen","Riverlea":"Riverlea","Riverside":"Riverside","Riviera Jhb":"Riviera Jhb","Rivonia":"Rivonia","Robertsham":"Robertsham","Robertville":"Robertville","Robin Acres":"Robin Acres","Robin Hills":"Robin Hills","Robin Park":"Robin Park","Robindale":"Robindale","Rondebult":"Rondebult","Roodekop":"Roodekop","Roodekrans":"Roodekrans","Roodepoort":"Roodepoort","Roodepoort North":"Roodepoort North","Roodepoort West":"Roodepoort West","Roods Gardens":"Roods Gardens","Roosevelt Park":"Roosevelt Park","Roospark A.H.":"Roospark A.H.","Roseacre":"Roseacre","Rosebank":"Rosebank","Rosettenville":"Rosettenville","Roshasia":"Roshasia","Rosherville":"Rosherville","Roshnee":"Roshnee","Rossmore":"Rossmore","Rothdene":"Rothdene","Rouxville":"Rouxville","Rowhill":"Rowhill","Roxton":"Roxton","Ruimsig":"Ruimsig","Ruimsig A.H.":"Ruimsig A.H.","Ruiterhof":"Ruiterhof","Rust-Ter-Vaal":"Rust-Ter-Vaal","Rustivia":"Rustivia","Rynfield":"Rynfield","Rynsoord":"Rynsoord","S.E. 1":"S.E. 1","S.E. 2":"S.E. 2","S.E. 3":"S.E. 3","S.E. 4":"S.E. 4","S.E. 5":"S.E. 5","S.E. 6":"S.E. 6","S.E. 7":"S.E. 7","S.E. 8":"S.E. 8","S.E. 9":"S.E. 9","S.W. 1":"S.W. 1","S.W. 2":"S.W. 2","S.W. 5":"S.W. 5","Sagewood":"Sagewood","Saldref A.H.":"Saldref A.H.","Salfred AH":"Salfred AH","Sali":"Sali","Salisbury Claims":"Salisbury Claims","Sallies":"Sallies","Sandhurst":"Sandhurst","Sandown":"Sandown","Sandpark A.H.":"Sandpark A.H.","Sandringham":"Sandringham","Sandton":"Sandton","Sappers Haven":"Sappers Haven","Sassobyl":"Sassobyl","Savoy Estate":"Savoy Estate","Saxonwold":"Saxonwold","Sebenza":"Sebenza","Sedibeng":"Sedibeng","Seet Waters":"Seet Waters","Selby":"Selby","Selcourt":"Selcourt","Selection Park":"Selection Park","Selwyn":"Selwyn","Senaone":"Senaone","Senderwood":"Senderwood","Sentrarand":"Sentrarand","Seotloana":"Seotloana","Sethebe":"Sethebe","Sethokga":"Sethokga","Seven Hundred Scheme":"Seven Hundred Scheme","Shalimar Ridge":"Shalimar Ridge","Shangrila A.H.":"Shangrila A.H.","Sharon Park":"Sharon Park","Sharondale":"Sharondale","Sharonlea":"Sharonlea","Sharpeville":"Sharpeville","Sherman Park":"Sherman Park","Sherwood Gardens":"Sherwood Gardens","Silvamonte":"Silvamonte","Silverfields":"Silverfields","Silverfields Park":"Silverfields Park","Simba":"Simba","Simmerfield":"Simmerfield","Skozana":"Skozana","Slaterville A.H.":"Slaterville A.H.","Slovo Park":"Slovo Park","Slovoville":"Slovoville","Solheim":"Solheim","Solridge":"Solridge","Sonlandpark":"Sonlandpark","Sonnedal A.H.":"Sonnedal A.H.","Sonneglans":"Sonneglans","Sonneveld":"Sonneveld","Sophiatown":"Sophiatown","Soteba":"Soteba","South Hills":"South Hills","South Kensington":"South Kensington","Southcrest":"Southcrest","Southdale":"Southdale","Southfork":"Southfork","Southgate":"Southgate","Soweto":"Soweto","Spartan":"Spartan","Spes Bona":"Spes Bona","Spoorhill":"Spoorhill","Springcol":"Springcol","Springfield":"Springfield","Springs":"Springs","Spruit View":"Spruit View","St. Andrews":"St. Andrews","Staalrus":"Staalrus","Staatsdorp":"Staatsdorp","Stafford":"Stafford","Steeledale":"Steeledale","Steelpark":"Steelpark","Steelvalley":"Steelvalley","Steelview":"Steelview","Stefano Park":"Stefano Park","Stesa A.H.":"Stesa A.H.","Steynsvlei":"Steynsvlei","Stormill":"Stormill","Stratford":"Stratford","Strathavon":"Strathavon","Stretford":"Stretford","Strijdompark":"Strijdompark","Struben Ridge A.H.":"Struben Ridge A.H.","Strubensvallei":"Strubensvallei","Strubensvalley":"Strubensvalley","Strubenvale":"Strubenvale","Struisbult":"Struisbult","Strydompark":"Strydompark","Suideroord":"Suideroord","Summerfield":"Summerfield","Summerset":"Summerset","Sunair Park":"Sunair Park","Sundowner":"Sundowner","Sunningdale":"Sunningdale","Sunningdale Ridge":"Sunningdale Ridge","Sunninghill":"Sunninghill","Sunnyridge":"Sunnyridge","Sunnyrock":"Sunnyrock","Sunnyside":"Sunnyside","Sunset Acres":"Sunset Acres","Sunward Park":"Sunward Park","Sybrand van Niekerk Park":"Sybrand van Niekerk Park","Sydenham":"Sydenham","Syferfontein 51-Ir":"Syferfontein 51-Ir","Sylviavale":"Sylviavale","Symhurst":"Symhurst","Talbot Park":"Talbot Park","Talboton":"Talboton","Tamboville":"Tamboville","Tanganani":"Tanganani","Teanong":"Teanong","Technikon":"Technikon","Tedderfield A.H.":"Tedderfield A.H.","Tedstoneville":"Tedstoneville","Tembisa":"Tembisa","Temong":"Temong","Terenure":"Terenure","Terenure A.H.":"Terenure A.H.","The Gables":"The Gables","The Gardens":"The Gardens","The Hill":"The Hill","The Reeds":"The Reeds","The Stewards":"The Stewards","The Woodlands":"The Woodlands","Thembelihle":"Thembelihle","Thembilisha":"Thembilisha","Theta":"Theta","Thintwa Village":"Thintwa Village","Thiteng":"Thiteng","Thornhill":"Thornhill","Three Rivers":"Three Rivers","Three Rivers East":"Three Rivers East","Three Trees":"Three Trees","Thulani":"Thulani","Tladi":"Tladi","Tlamatlama":"Tlamatlama","Toekomsrus":"Toekomsrus","Tokoza":"Tokoza","Tokyo":"Tokyo","Tornado":"Tornado","Towerby":"Towerby","Townsview":"Townsview","Tres Jolie":"Tres Jolie","Tres Jolie A.H.":"Tres Jolie A.H.","Trevallyn A.H.":"Trevallyn A.H.","Triomf":"Triomf","Trojan":"Trojan","Troyeville":"Troyeville","Tsakane":"Tsakane","Tsenolong":"Tsenolong","Tsepo":"Tsepo","Tshepiso":"Tshepiso","Tshepisong":"Tshepisong","Tsolo":"Tsolo","Tsongweni":"Tsongweni","Tulisa Park":"Tulisa Park","Tunney":"Tunney","Turf Club":"Turf Club","Turffontein":"Turffontein","Twala":"Twala","Uitsaaisentrum":"Uitsaaisentrum","Ulana Park":"Ulana Park","Umfuyaneni":"Umfuyaneni","Umnonjaneni":"Umnonjaneni","Umthambeka":"Umthambeka","Unaville A.H.":"Unaville A.H.","Unigray":"Unigray","Union":"Union","Union Settlement":"Union Settlement","Unitas Park":"Unitas Park","Ussher":"Ussher","Vaaldam":"Vaaldam","Vaalkop":"Vaalkop","Valentine Village":"Valentine Village","Valeriedene":"Valeriedene","Valley Settlements 1":"Valley Settlements 1","Valley Settlements 2":"Valley Settlements 2","Valley Settlements 3":"Valley Settlements 3","Van Dyk Park":"Van Dyk Park","Van Eck Park":"Van Eck Park","Van Riebeeckpark":"Van Riebeeckpark","Van Ryn S.H.":"Van Ryn S.H.","Vandermerweskroon":"Vandermerweskroon","Vandia Grove":"Vandia Grove","Vanwartshof":"Vanwartshof","Vergenoeg":"Vergenoeg","Verwoerd Park":"Verwoerd Park","Victoria":"Victoria","Victory Park":"Victory Park","Vierfontein":"Vierfontein","View Crest":"View Crest","Viewcrest":"Viewcrest","Viljoensdrif":"Viljoensdrif","Villa Liza":"Villa Liza","Village Deep":"Village Deep","Village Main":"Village Main","Visagie Park":"Visagie Park","Vlakfontein":"Vlakfontein","Vogelstruisfontein":"Vogelstruisfontein","Vongeusauspark":"Vongeusauspark","Vorna Valley":"Vorna Valley","Vorster Park":"Vorster Park","Vorsterkroon":"Vorsterkroon","Vosloorus":"Vosloorus","Vred":"Vred","Vrededorp":"Vrededorp","Vredepark":"Vredepark","Vulcania":"Vulcania","Vusimusi":"Vusimusi","Wadeville":"Wadeville","Waldrif":"Waldrif","Walkers Fruit Farms":"Walkers Fruit Farms","Walkerville":"Walkerville","Walkerville Manor":"Walkerville Manor","Wannenburghoogte":"Wannenburghoogte","Waterdal":"Waterdal","Waterfall City":"Waterfall City","Waterfall Estate":"Waterfall Estate","Waterfall Park":"Waterfall Park","Waterford":"Waterford","Waterval":"Waterval","Waterval A.H.":"Waterval A.H.","Waterval Estate":"Waterval Estate","Waterval Park":"Waterval Park","Wattville":"Wattville","Waverley":"Waverley","Webber":"Webber","Weilers Farm":"Weilers Farm","Welgedacht":"Welgedacht","Welgedacht S.H.":"Welgedacht S.H.","Welomlambo":"Welomlambo","Weltevredenpark":"Weltevredenpark","Wemmer":"Wemmer","Wendywood":"Wendywood","Wentworth Park":"Wentworth Park","Wesco Park":"Wesco Park","West Germiston":"West Germiston","West Porges":"West Porges","West Rand A.H.":"West Rand A.H.","West Turffontein":"West Turffontein","Westbury":"Westbury","Westcliff":"Westcliff","Westdene":"Westdene","Westdene (Benoni)":"Westdene (Benoni)","Westergloor":"Westergloor","Westfield":"Westfield","Westgate":"Westgate","Westside Park":"Westside Park","Westwood S.H.":"Westwood S.H.","Wheatlands A.H.":"Wheatlands A.H.","White City":"White City","Whiteridge":"Whiteridge","Whitney Gardens":"Whitney Gardens","Wibsey Dip":"Wibsey Dip","Wierda Valley":"Wierda Valley","Wilbart":"Wilbart","Wilbotsdal A.H.":"Wilbotsdal A.H.","Wilfordon":"Wilfordon","Wilgeheuwel":"Wilgeheuwel","Wilgespruit 190-Iq":"Wilgespruit 190-Iq","Willaway":"Willaway","Willowbrook":"Willowbrook","Willowdale":"Willowdale","Willowild":"Willowild","Wilro Park":"Wilro Park","Winchester Hills":"Winchester Hills","Windmill Park":"Windmill Park","Windsor":"Windsor","Windsor East":"Windsor East","Windsor Glen":"Windsor Glen","Windsor West":"Windsor West","Winford A.H.":"Winford A.H.","Winnie Camp":"Winnie Camp","Winston Ridge":"Winston Ridge","Witbos":"Witbos","Witfield":"Witfield","Witfontein":"Witfontein","Withok Estates":"Withok Estates","Witkopdorp; Randvaal":"Witkopdorp; Randvaal","Witkoppen":"Witkoppen","Witkoppie Ridge":"Witkoppie Ridge","Witpoort":"Witpoort","Witpoort (Beaulieu)":"Witpoort (Beaulieu)","Witpoort Estates":"Witpoort Estates","Witpoortjie":"Witpoortjie","Witsloot":"Witsloot","Wolhuter":"Wolhuter","Woodlands":"Woodlands","Woodmead":"Woodmead","Woodmead East":"Woodmead East","Woodmere":"Woodmere","Wright Park":"Wright Park","Wychwood":"Wychwood","Wyman Park":"Wyman Park","Wynberg":"Wynberg","Xtombiza":"Xtombiza","Xubene":"Xubene","Yeoville":"Yeoville","Zakariyya Park":"Zakariyya Park","Zandfontein":"Zandfontein","Zandspruit":"Zandspruit","Zevenfontein":"Zevenfontein","Zola":"Zola","Zondi":"Zondi","Zonnehoewe A.H.":"Zonnehoewe A.H.","Zuma":"Zuma","Zuurbekom":"Zuurbekom","Zuurfontein":"Zuurfontein","Zwartkopjes":"Zwartkopjes"}},"Jonkershoek":{"items":{"CBD":"CBD"}},"Joubertina":{"items":{"CBD":"CBD"}},"Jouberton":{"items":{"CBD":"CBD"}},"Jozini":{"items":{"CBD":"CBD"}},"Ka Nwamankena":{"items":{"CBD":"CBD"}},"Kaapmuiden":{"items":{"CBD":"CBD"}},"Kabe":{"items":{"CBD":"CBD"}},"Kabokweni":{"items":{"CBD":"CBD"}},"Kakamas":{"items":{"CBD":"CBD"}},"Kalbaskraal":{"items":{"CBD":"CBD"}},"Kalkbank":{"items":{"CBD":"CBD"}},"Kamaqhekeza":{"items":{"CBD":"CBD"}},"Kamberg":{"items":{"CBD":"CBD"}},"Kameel":{"items":{"CBD":"CBD"}},"Kameeldrift":{"items":{"CBD":"CBD"}},"Kamhlushwa":{"items":{"CBD":"CBD"}},"Kamieskroon":{"items":{"CBD":"CBD"}},"Kampersrus":{"items":null},"Kanon Eiland":{"items":null},"KaNyamazane":{"items":null},"Karatara":{"items":null},"Kareedouw":{"items":null},"Karino":{"items":null},"Karridene":{"items":null},"Kathu":{"items":null},"Kaysers Beach":{"items":null},"Kei Mouth":{"items":null},"Keimoes":{"items":null},"Keiskammahoek":{"items":null},"Kendal":{"items":null},"Kenhardt":{"items":null},"Kenilworth, EC":{"items":null},"Kentani":{"items":null},"Kenton-on-Sea":{"items":{"CBD":"CBD"}},"Kestell":{"items":{"CBD":"CBD"}},"Keurboomstrand":{"items":{"CBD":"CBD"}},"Kgapane":{"items":{"CBD":"CBD"}},"Kgokgojane":{"items":{"CBD":"CBD"}},"Kgokgole":{"items":{"CBD":"CBD"}},"Khayalitsha":{"items":{"CBD":"CBD"}},"Khayelitsha":{"items":{"CBD":"CBD"}},"Khunkwe":{"items":{"CBD":"CBD"}},"Khutsong":{"items":{"CBD":"CBD"}},"Kidds Beach":{"items":{"CBD":"CBD"}},"Kiepersol":{"items":{"CBD":"CBD"}},"Kimberley":{"items":{"Albertynshof":"Albertynshof","Beaconsfeild":"Beaconsfeild","Belgravia":"Belgravia","Casandra":"Casandra","CBD":"CBD","De Beers":"De Beers","El Toro Park":"El Toro Park","Galeshewe":"Galeshewe","Hadison Park":"Hadison Park","Herlear":"Herlear","Hillcrest":"Hillcrest","Homestead":"Homestead","Homevale":"Homevale","Kestellhof":"Kestellhof","Kimdustria":"Kimdustria","Mogul Park":"Mogul Park","Monument Heights":"Monument Heights","New Park":"New Park","Northview":"Northview","Rhodesdene":"Rhodesdene","Royal Glen":"Royal Glen","Royldene":"Royldene","Vergenoeg":"Vergenoeg","West End":"West End"}},"King Williams Town":{"items":{"CBD":"CBD"}},"Kingsburgh":{"items":{"CBD":"CBD","St Winifreds":"St Winifreds"}},"Kini Bay":{"items":{"CBD":"CBD"}},"Kinross":{"items":{"CBD":"CBD"}},"Kirkwood":{"items":{"CBD":"CBD"}},"Klapmuts":{"items":{"CBD":"CBD"}},"Klaserie":{"items":{"CBD":"CBD"}},"Klawer":{"items":{"CBD":"CBD"}},"Klein Brak River":{"items":{"CBD":"CBD"}},"Kleinemonde":{"items":{"CBD":"CBD"}},"Kleinfontein":{"items":{"CBD":"CBD"}},"Kleinfontein - MPUM":{"items":{"CBD":"CBD"}},"Kleinmond":{"items":{"CBD":"CBD"}},"Kleinzee":{"items":{"CBD":"CBD"}},"Klerksdorp":{"items":{"Adamayview":"Adamayview","CBD":"CBD","Flamwood":"Flamwood","Flimieda":"Flimieda","La Hoff":"La Hoff","Uraniaville":"Uraniaville","Wilkoppies":"Wilkoppies"}},"Klipdrif":{"items":{"CBD":"CBD"}},"Klipfontein":{"items":{"CBD":"CBD"}},"Klipheuwel":{"items":{"CBD":"CBD"}},"Kliprivier - KZN":{"items":{"CBD":"CBD"}},"Knysna":{"items":{"Belvidere Estate":"Belvidere Estate","CBD":"CBD","Hunters Home":"Hunters Home","Leisure Island":"Leisure Island","Leisure Isle":"Leisure Isle","Paradise":"Paradise","Thesen Island":"Thesen Island"}},"Koedoeskop":{"items":{"CBD":"CBD"}},"Koekenap":{"items":{"CBD":"CBD"}},"Koffiefontein":{"items":{"CBD":"CBD"}},"Koingnaas":{"items":{"CBD":"CBD"}},"Kokstad":{"items":{"CBD":"CBD"}},"Kokwane":{"items":{"CBD":"CBD"}},"Komati":{"items":{"CBD":"CBD"}},"Komatiepoort":{"items":{"CBD":"CBD"}},"Komga":{"items":{"CBD":"CBD"}},"Koopmansfontein":{"items":{"CBD":"CBD"}},"Kopfontein":{"items":{"CBD":"CBD"}},"Koppies":{"items":{"CBD":"CBD"}},"Koringberg":{"items":{"CBD":"CBD"}},"Kosi Bay":{"items":{"CBD":"CBD"}},"Koster":{"items":{"CBD":"CBD","Cedrela":"Cedrela"}},"Kraaipan Town":{"items":{"CBD":"CBD"}},"Krakeel":{"items":{"CBD":"CBD"}},"Kranskop":{"items":{"CBD":"CBD"}},"Krantshoek":{"items":{"CBD":"CBD"}},"Kriel":{"items":{"CBD":"CBD"}},"Kromdraai":{"items":{"CBD":"CBD"}},"Kromellenboog":{"items":{"CBD":"CBD"}},"Kromfontein":{"items":{"CBD":"CBD"}},"Kroondal":{"items":{"CBD":"CBD"}},"Kroonstad":{"items":{"CBD":"CBD"}},"Kudunkwane":{"items":{"CBD":"CBD"}},"Kuruman":{"items":{"CBD":"CBD"}},"Kwa Mashu":{"items":{"CBD":"CBD"}},"Kwa Mbonambi":{"items":{"CBD":"CBD"}},"Kwa-Dlangezwa":{"items":{"CBD":"CBD"}},"KwaDabeka":{"items":{"CBD":"CBD"}},"KwaDukuza":{"items":{"CBD":"CBD"}},"Kwaggafontein":{"items":{"CBD":"CBD"}},"Kwahlabisa":{"items":{"CBD":"CBD"}},"Kwambonambi":{"items":{"CBD":"CBD"}},"Kwamhlanga":{"items":{"CBD":"CBD"}},"KwaNgwanase":{"items":{"CBD":"CBD"}},"Kwazakhele":{"items":{"CBD":"CBD","Kwazakhele":"Kwazakhele"}},"Kwelera":{"items":{"CBD":"CBD"}},"Laaiplek":{"items":{"CBD":"CBD"}},"Ladismith - Cape":{"items":{"CBD":"CBD"}},"Lady Frere":{"items":{"CBD":"CBD"}},"Lady Grey":{"items":{"CBD":"CBD"}},"Ladybrand":{"items":{"CBD":"CBD"}},"Ladysmith - KZN":{"items":{"CBD":"CBD"}},"Laingsburg":{"items":{"CBD":"CBD"}},"Lamberts Bay":{"items":{"CBD":"CBD"}},"Lambertsbay":{"items":{"CBD":"CBD"}},"Langa":{"items":{"CBD":"CBD"}},"Langebaan":{"items":{"CBD":"CBD"}},"Leandra":{"items":{"CBD":"CBD"}},"Lebohang":{"items":{"CBD":"CBD"}},"Lebotloane":{"items":{"CBD":"CBD"}},"Lebowakgomo":{"items":{"CBD":"CBD"}},"Leeu Gamka":{"items":{"CBD":"CBD"}},"Leeudoringstad":{"items":null},"Leeupoort":{"items":null},"Leeuwfontein":{"items":null},"Lehurutse":{"items":null},"Leipoldtville":{"items":null},"Leisure Bay":{"items":null},"Lekgolo":{"items":null},"Lenyenye":{"items":null},"Lephalale":{"items":null},"Leroro B":{"items":null},"Leslie":{"items":null},"Letaba":{"items":null},"Lethlabile":{"items":null},"Letsitele":{"items":null},"Levubu":{"items":null},"Libertas":{"items":null},"Libode":{"items":{"CBD":"CBD"}},"Lichtenburg":{"items":{"CBD":"CBD","Shukran":"Shukran"}},"Lidgetton":{"items":{"CBD":"CBD"}},"Lime Acres":{"items":{"CBD":"CBD"}},"Lindley":{"items":{"CBD":"CBD"}},"Lions River":{"items":{"CBD":"CBD"}},"Little":{"items":{"CBD":"CBD"}},"Loerie":{"items":{"CBD":"CBD"}},"Loeriesfontein":{"items":{"CBD":"CBD"}},"Logagane":{"items":{"CBD":"CBD"}},"Logageng":{"items":{"CBD":"CBD"}},"Loskop - KZN":{"items":{"CBD":"CBD"}},"Loskopdam":{"items":{"CBD":"CBD"}},"Lothair":{"items":{"CBD":"CBD"}},"Lotlapakgoro":{"items":{"CBD":"CBD"}},"Lotus Gardens - PTA":{"items":{"CBD":"CBD"}},"Louis Trichardt":{"items":{"CBD":"CBD"}},"Louterwater":{"items":{"CBD":"CBD"}},"Louws Creek":{"items":{"CBD":"CBD"}},"Louwsburg":{"items":{"CBD":"CBD"}},"Loxton":{"items":{"CBD":"CBD"}},"Luckhoff":{"items":{"CBD":"CBD"}},"Lulekani":{"items":{"CBD":"CBD"}},"Lusikisiki":{"items":{"CBD":"CBD"}},"Lutzville":{"items":{"CBD":"CBD"}},"Lydenburg":{"items":{"CBD":"CBD"}},"Lynedoch":{"items":{"CBD":"CBD"}},"Maake":{"items":{"CBD":"CBD"}},"Mabalstad":{"items":{"CBD":"CBD"}},"Mabeskraal":{"items":{"CBD":"CBD"}},"Maboloka":{"items":null},"Mabopane":{"items":null},"Mabule":{"items":null},"Machadodorp":{"items":null},"Macleantown":{"items":null},"Maclear":{"items":null},"Madadeni":{"items":null},"Madibogo":{"items":{"CBD":"CBD"}},"Madibogo Pan":{"items":{"CBD":"CBD"}},"Madikwe":{"items":{"CBD":"CBD"}},"Maeng":{"items":{"CBD":"CBD"}},"Maeyaeyane":{"items":{"CBD":"CBD"}},"Mafikeng":{"items":{"CBD":"CBD","Golf View":"Golf View","Mmabatho":"Mmabatho"}},"Magakala":{"items":{"CBD":"CBD"}},"Magaliesburg":{"items":{"CBD":"CBD"}},"Magoebaskloof":{"items":{"CBD":"CBD"}},"Magogong":{"items":{"CBD":"CBD"}},"Mahlabatini":{"items":{"CBD":"CBD"}},"Mahushu":{"items":{"CBD":"CBD"}},"Mahwelereng":{"items":{"CBD":"CBD"}},"Maipeng":{"items":{"CBD":"CBD"}},"Majaneng":{"items":{"CBD":"CBD"}},"Majuba Power Station":{"items":{"CBD":"CBD"}},"Makapanstad":{"items":{"CBD":"CBD"}},"Makgori":{"items":{"CBD":"CBD"}},"Makhane":{"items":{"CBD":"CBD"}},"Makokskraal":{"items":{"CBD":"CBD"}},"Makwassie":{"items":{"CBD":"CBD"}},"Malamulele":{"items":{"CBD":"CBD"}},"Malelane":{"items":{"CBD":"CBD"}},"Malmesbury":{"items":{"CBD":"CBD"}},"Malomeni":{"items":{"CBD":"CBD"}},"Maluti":{"items":{"CBD":"CBD"}},"Mamelodi - PTA":{"items":{"CBD":"CBD"}},"Mamogaleskraal":{"items":{"CBD":"CBD"}},"Mamre":{"items":{"CBD":"CBD"}},"Manaba Beach":{"items":{"CBD":"CBD"}},"Mananga":{"items":null},"Mandeni":{"items":null},"Mandini":{"items":null},"Manguzi":{"items":null},"Mankaipaya":{"items":null},"Mankweng":{"items":null},"Maphumulo":{"items":null},"Marapong":{"items":null},"Marapyane":{"items":null},"Marble Hall":{"items":null},"Marchand":{"items":null},"Mareetsane":{"items":null},"Margate":{"items":null},"Marikana":{"items":null},"Marina Beach":{"items":null},"Marken":{"items":null},"Marloth Park":{"items":null},"Marquard":{"items":null},"Marseilles":{"items":null},"Marydale":{"items":null},"Masamane":{"items":null},"Masipumelele":{"items":null},"Master Williamville":{"items":null},"Maswazini":{"items":null},"Mataffin":{"items":null},"Matatiele":{"items":null},"Mathibestad":{"items":null},"Mathopestad":{"items":null},"Matjiesfontein":{"items":null},"Matlhabatlhaba":{"items":null},"Matoks":{"items":null},"Maubane":{"items":null},"Mazista":{"items":null},"Mbazwana":{"items":null},"Mbizana":{"items":null},"Mbongolwane":{"items":null},"McGregor":{"items":null},"Mdantsane":{"items":null},"Meerlus":{"items":null},"Melmoth":{"items":null},"Memel":{"items":null},"Merrivale":{"items":null},"Merweville":{"items":null},"Meyerton":{"items":null},"Mhlabatini":{"items":null},"Mhluzi":{"items":null},"Mica":{"items":null},"Middelburg - EC":{"items":null},"Middelburg - MP":{"items":{"Aerorand":"Aerorand","CBD":"CBD","Clubville":"Clubville","Dennesig":"Dennesig","Eastdene":"Eastdene","Elandspruit":"Elandspruit","Golfsig":"Golfsig","Industria":"Industria","Kanonkop":"Kanonkop","Midlands Estate":"Midlands Estate","Mineralia":"Mineralia","Vaalbank":"Vaalbank"}},"Middledrift":{"items":{"CBD":"CBD"}},"Mier":{"items":{"CBD":"CBD"}},"Migdol":{"items":{"CBD":"CBD"}},"Mineralia":{"items":{"CBD":"CBD"}},"Misgund":{"items":{"CBD":"CBD"}},"Missionvale - PLZ":{"items":{"CBD":"CBD"}},"Mkhuhlu":{"items":{"CBD":"CBD"}},"Mkondeni":{"items":{"CBD":"CBD"}},"Mkuze":{"items":{"CBD":"CBD"}},"Mmabatho":{"items":{"CBD":"CBD"}},"Mmagabue":{"items":{"CBD":"CBD"}},"Mmakaunyana":{"items":{"CBD":"CBD"}},"Mmakaunyane":{"items":{"CBD":"CBD"}},"Mmatlhwaela":{"items":{"CBD":"CBD"}},"Mmukubyane":{"items":{"CBD":"CBD"}},"Mntunzini":{"items":{"CBD":"CBD"}},"Modderrivier":{"items":{"CBD":"CBD"}},"Modimolle":{"items":{"CBD":"CBD"}},"Modjadjiskloof":{"items":{"CBD":"CBD"}},"Moeka":{"items":{"CBD":"CBD"}},"Mogogelo":{"items":{"CBD":"CBD"}},"Mogogolelo":{"items":{"CBD":"CBD"}},"Mogohlwaneng":{"items":{"CBD":"CBD"}},"Mogwase":{"items":{"CBD":"CBD"}},"Mokgobistad":{"items":{"CBD":"CBD"}},"Mokonene":{"items":{"CBD":"CBD"}},"Mokopane":{"items":{"CBD":"CBD","Chroompark":"Chroompark"}},"Moletji":{"items":{"CBD":"CBD"}},"Moloto":{"items":{"CBD":"CBD"}},"Molteno":{"items":{"CBD":"CBD"}},"Monetsi":{"items":{"CBD":"CBD"}},"Monsterlus":{"items":{"CBD":"CBD"}},"Montagu":{"items":{"CBD":"CBD"}},"Mooi River":{"items":{"CBD":"CBD"}},"Mooinooi":{"items":{"CBD":"CBD"}},"Mooketsi":{"items":{"CBD":"CBD"}},"Mookgopong":{"items":{"CBD":"CBD"}},"Moorreesburg":{"items":{"CBD":"CBD"}},"Morebeng":{"items":{"CBD":"CBD"}},"Moretele":{"items":{"CBD":"CBD"}},"Morgan Bay":{"items":{"CBD":"CBD"}},"Morgenzon":{"items":{"CBD":"CBD"}},"Morokweng":{"items":{"CBD":"CBD"}},"Morotsi":{"items":{"CBD":"CBD"}},"Moruleng":{"items":{"CBD":"CBD"}},"Mossel Bay":{"items":{"CBD":"CBD","D Almeida":"D Almeida","Danabaai":"Danabaai","De Bakke":"De Bakke","De Nova":"De Nova","Heiderand":"Heiderand","Voorbaai":"Voorbaai"}},"Moswana":{"items":{"CBD":"CBD"}},"Motetema":{"items":{"CBD":"CBD"}},"Moteti":{"items":{"CBD":"CBD"}},"Mothibistad":{"items":{"CBD":"CBD"}},"Motlhabeng Village":{"items":{"CBD":"CBD"}},"Mototolo Mine":{"items":{"CBD":"CBD"}},"Motswedi":{"items":{"CBD":"CBD"}},"Mount Ayliff":{"items":{"CBD":"CBD"}},"Mount Fletcher":{"items":{"CBD":"CBD"}},"Mount Frere":{"items":{"CBD":"CBD"}},"Mpuluzi":{"items":{"CBD":"CBD"}},"Mqanduli":{"items":{"CBD":"CBD"}},"Mseleni":{"items":null},"Mthatha":{"items":null},"Mtubatuba":{"items":null},"Mtunzini":{"items":null},"Mtwalume":{"items":null},"Muden":{"items":null},"Munster":{"items":null},"Murraysburg":{"items":null},"Musina":{"items":{"CBD":"CBD"}},"Mutale":{"items":{"CBD":"CBD"}},"Nababeep":{"items":{"CBD":"CBD"}},"Naboomspruit":{"items":{"CBD":"CBD"}},"Namakgale":{"items":{"CBD":"CBD"}},"Napier":{"items":{"CBD":"CBD"}},"Natures Valley":{"items":{"CBD":"CBD"}},"Nautilus Bay":{"items":{"CBD":"CBD"}},"Ndwedwe":{"items":{"CBD":"CBD"}},"Nebo":{"items":{"CBD":"CBD"}},"Nelspoort":{"items":{"CBD":"CBD"}},"Nelspruit":{"items":{"CBD":"CBD","Kamagugu":"Kamagugu","Nelsville":"Nelsville","Riverside Park":"Riverside Park","Sonheuwel":"Sonheuwel","Valencia":"Valencia","West Acres":"West Acres"}},"New Brighton":{"items":{"New Brighton":"New Brighton"}},"New Eersterus":{"items":{"CBD":"CBD"}},"New Hanover":{"items":{"CBD":"CBD"}},"New Kraaipan":{"items":{"CBD":"CBD"}},"New Machavie":{"items":{"CBD":"CBD"}},"Newcastle":{"items":{"Avairy Hill":"Avairy Hill","Barry Hertzog Park":"Barry Hertzog Park","CBD":"CBD","Hutten Heights":"Hutten Heights","Madadeni":"Madadeni","Osizweni":"Osizweni","Pioneer Park":"Pioneer Park","Riverside Industrial":"Riverside Industrial","Schuinshoogte":"Schuinshoogte","Signal Hill":"Signal Hill"}},"Ngcobo":{"items":{"CBD":"CBD"}},"Ngobi":{"items":{"CBD":"CBD"}},"Ngodwana":{"items":{"CBD":"CBD"}},"Ngqeleni":{"items":{"CBD":"CBD"}},"Nietverdien":{"items":{"CBD":"CBD"}},"Nieu Bethesda":{"items":{"CBD":"CBD"}},"Nieuwoudtville":{"items":{"CBD":"CBD"}},"Nigel":{"items":{"CBD":"CBD","Ferryvale":"Ferryvale","Mackenzieville":"Mackenzieville"}},"Nkandla":{"items":{"CBD":"CBD"}},"Nkomazi":{"items":{"CBD":"CBD"}},"Nkonjeni":{"items":{"CBD":"CBD"}},"Nkowankowa":{"items":{"CBD":"CBD"}},"Noll":{"items":null},"Nongoma":{"items":null},"Noordkaap, Mpumalanga":{"items":null},"Noordsberg":{"items":null},"Nora Falls":{"items":null},"Noroki":{"items":null},"Northam":{"items":null},"Norvalspont":{"items":null},"Nottingham Road":{"items":{"CBD":"CBD"}},"Noupoort":{"items":{"CBD":"CBD"}},"Nqamakwe":{"items":{"CBD":"CBD"}},"Nqutu":{"items":{"CBD":"CBD"}},"Nseleni":{"items":{"CBD":"CBD"}},"Nyanga":{"items":{"CBD":"CBD"}},"Nylstroom":{"items":{"CBD":"CBD"}},"Oberholzer":{"items":{"CBD":"CBD"}},"Odendaalsrus":{"items":{"CBD":"CBD"}},"Ofcolaco":{"items":{"CBD":"CBD"}},"Ogies":{"items":{"CBD":"CBD"}},"Ohrigstad":{"items":{"CBD":"CBD"}},"Okiep":{"items":{"CBD":"CBD"}},"Old Kraaipan":{"items":{"CBD":"CBD"}},"Olievenhoutbosch - PTA":{"items":{"CBD":"CBD"}},"Olifantshoek":{"items":{"CBD":"CBD"}},"Olverton":{"items":{"CBD":"CBD"}},"Onrus Rivier":{"items":{"CBD":"CBD"}},"Onverwacht":{"items":{"CBD":"CBD"}},"Op-Die-Berg":{"items":{"CBD":"CBD"}},"Opperman":{"items":{"CBD":"CBD"}},"Orania":{"items":{"CBD":"CBD"}},"Oranjeville":{"items":{"CBD":"CBD"}},"Oribi Flats":{"items":{"CBD":"CBD"}},"Orkney":{"items":null},"Oshoek":{"items":null},"Ottosdal":{"items":null},"Ottoshoop":{"items":null},"Oudtshoorn":{"items":null},"Ovistone":{"items":null},"Ozwathini":{"items":null},"Paarl":{"items":null},"Paarl Farms":{"items":null},"Pachsdraai":{"items":null},"Paddock":{"items":null},"Palm Beach":{"items":null},"Palmietfontein - LP":{"items":null},"Pampierstad":{"items":null},"Panbult":{"items":null},"Papendorp":{"items":null},"Paradise Beach":{"items":null},"Park Rynie":{"items":null},"Parys":{"items":null},"Patensie":{"items":null},"Paternoster":{"items":null},"Paterson":{"items":null},"Paul Kruger Gate (Kruger National Park)":{"items":null},"Paul Roux":{"items":null},"Paulpietersburg":{"items":null},"Pearly Beach":{"items":null},"Pearston":{"items":null},"Peddie":{"items":null},"Pelindaba":{"items":null},"Pella":{"items":null},"Pembroke":{"items":null},"Pennington":{"items":null},"Perdeberg":{"items":null},"Perdekop":{"items":null},"Petrus Steyn":{"items":null},"Petrusburg":{"items":null},"Petrusville":{"items":null},"Phalaborwa":{"items":null},"Phaposane":{"items":null},"Philadelphia":{"items":null},"Philippi":{"items":null},"Philipstown":{"items":null},"Phillipolis":{"items":{"CBD":"CBD"}},"Phinda Private Game Reserve":{"items":{"CBD":"CBD"}},"Phokeng":{"items":{"CBD":"CBD"}},"Phokwane":{"items":{"CBD":"CBD"}},"Phola":{"items":{"CBD":"CBD"}},"Phuthaditjhaba":{"items":{"CBD":"CBD"}},"Pienaarsrivier":{"items":{"CBD":"CBD"}},"Piet Plessis":{"items":{"CBD":"CBD"}},"Piet Retief":{"items":{"CBD":"CBD"}},"Pietermaritzburg":{"items":{"Allandale":"Allandale","Ashburton":"Ashburton","Ashwood":"Ashwood","Athlone":"Athlone","Belfort Estate":"Belfort Estate","Bellevue":"Bellevue","Bisley":"Bisley","Bisley Crest":"Bisley Crest","Bisley Heights":"Bisley Heights","Blackridge":"Blackridge","Bombay Heights":"Bombay Heights","Boughton":"Boughton","Camps Drift":"Camps Drift","CBD":"CBD","Chase Valley":"Chase Valley","Chase Valley Downs":"Chase Valley Downs","Chase Valley Heights":"Chase Valley Heights","Chasedene":"Chasedene","Clarendon":"Clarendon","Cleland":"Cleland","Copesville":"Copesville","Dambuza":"Dambuza","Dunveria":"Dunveria","Eastwood":"Eastwood","Edendale":"Edendale","Edendale East":"Edendale East","Epworth":"Epworth","Ferncliffe":"Ferncliffe","Fillan Park":"Fillan Park","Harewood":"Harewood","Hayfields":"Hayfields","Hazelmere":"Hazelmere","Imbali":"Imbali","Kingston Park":"Kingston Park","Lester Park":"Lester Park","Lincoln Meade":"Lincoln Meade","Lotusville":"Lotusville","Macibise":"Macibise","Maqeleni":"Maqeleni","Mason\'s Mill":"Mason\'s Mill","Mkondeni":"Mkondeni","Montrose":"Montrose","Mountain Rise":"Mountain Rise","Mpumuza":"Mpumuza","Mysore Ridge":"Mysore Ridge","Newholme":"Newholme","Northdale":"Northdale","Northern Park":"Northern Park","Oak Park":"Oak Park","Oribi Heights":"Oribi Heights","Oribi Village":"Oribi Village","Orient Heights":"Orient Heights","Panorama Gardens":"Panorama Gardens","Payipini":"Payipini","Pelham":"Pelham","Pentrich":"Pentrich","Plessislaer":"Plessislaer","Prestbury":"Prestbury","Raisethorpe":"Raisethorpe","Richmond Crest":"Richmond Crest","Ridge Park":"Ridge Park","Ridgepark":"Ridgepark","Rosedale":"Rosedale","Samanville":"Samanville","Scottsville":"Scottsville","Shortts Retreat":"Shortts Retreat","Signal Hill":"Signal Hill","Slangspruit":"Slangspruit","Sobantu":"Sobantu","Sunnyside":"Sunnyside","The Grange":"The Grange","The Meadows":"The Meadows","Town Bush Valley":"Town Bush Valley","Town Hill":"Town Hill","Upper Ferncliffe":"Upper Ferncliffe","Wembley":"Wembley","Westgate":"Westgate","Willowton":"Willowton","Woodlands":"Woodlands","World\'s View":"World\'s View"}},"Piketberg":{"items":{"CBD":"CBD"}},"Pilanesburg":{"items":{"CBD":"CBD"}},"Pilgrims Rest":{"items":{"CBD":"CBD"}},"Plettenberg Bay":{"items":{"CBD":"CBD","Robberg Ridge":"Robberg Ridge"}},"Pniel":{"items":{"CBD":"CBD"}},"Pofadder":{"items":{"CBD":"CBD"}},"Politsi":{"items":{"CBD":"CBD"}},"Polokwane":{"items":{"Bendor":"Bendor","Capricorn":"Capricorn","CBD":"CBD","Doornbult":"Doornbult","Florapark":"Florapark","Ladine":"Ladine","Nirvana":"Nirvana","Polokwane Central":"Polokwane Central","Seshego":"Seshego","Sterpark":"Sterpark","Superbia":"Superbia"}},"Pomeroy":{"items":{"CBD":"CBD"}},"Pomfret":{"items":{"CBD":"CBD"}},"Pongola":{"items":{"CBD":"CBD"}},"Port Alfred":{"items":{"CBD":"CBD"}},"Port Edward":{"items":{"CBD":"CBD"}},"Port Elizabeth":{"items":{"Adcockvale":"Adcockvale","Alexander Park Industrial":"Alexander Park Industrial","Algoa Park":"Algoa Park","Allanridge West":"Allanridge West","Amsterdamhoek":"Amsterdamhoek","Arcadia":"Arcadia","Azalea Park":"Azalea Park","Beachview":"Beachview","Benkamma":"Benkamma","Bethelsdorp":"Bethelsdorp","Beverley Grove":"Beverley Grove","Blikkiesdorp":"Blikkiesdorp","Bloemendal A.H":"Bloemendal A.H","Bluewater Bay":"Bluewater Bay","Boastville":"Boastville","Booysen Park":"Booysen Park","Botharus":"Botharus","Bramhope":"Bramhope","Bridgemeade":"Bridgemeade","Broadwood":"Broadwood","Brymore":"Brymore","Buffelsfontein":"Buffelsfontein","Campher Park":"Campher Park","Cannon Hill":"Cannon Hill","Cape Road Industrial":"Cape Road Industrial","Cetuville":"Cetuville","Charlo":"Charlo","Chatty":"Chatty","Chelsea":"Chelsea","Clarendon Marine":"Clarendon Marine","Cleary Estate":"Cleary Estate","Clearypark":"Clearypark","Coega":"Coega","Colleen Glen":"Colleen Glen","Cotswold":"Cotswold","Cradock Place":"Cradock Place","Cresthaven":"Cresthaven","Crestview":"Crestview","Curry":"Curry","Cuyler Manor":"Cuyler Manor","Daleview":"Daleview","De Mist":"De Mist","Deal Party":"Deal Party","Despatch":"Despatch","Dr.Brown":"Dr.Brown","Elundini":"Elundini","Eric Dodd":"Eric Dodd","Essexdale":"Essexdale","Fairbridge Heights":"Fairbridge Heights","Fairview":"Fairview","Fernglen":"Fernglen","Floral Park":"Floral Park","Forest Hill":"Forest Hill","Framesby":"Framesby","Framesby North":"Framesby North","Francis Evatt Park":"Francis Evatt Park","Gelvan Park":"Gelvan Park","Gelvandale":"Gelvandale","Gerald Smith":"Gerald Smith","Gillets":"Gillets","Glendinningvale":"Glendinningvale","Glenhurd":"Glenhurd","Glenroy Park":"Glenroy Park","Goldwater":"Goldwater","Govan Mbeki":"Govan Mbeki","Grange":"Grange","Greenacres":"Greenacres","Greenbushes":"Greenbushes","Greenshields Park":"Greenshields Park","Harmony":"Harmony","Heatherbank":"Heatherbank","Helenvale":"Helenvale","Heuwelkruin":"Heuwelkruin","Hillside":"Hillside","Holland Park":"Holland Park","Humewood":"Humewood","Hunters Retreat":"Hunters Retreat","Ibhayi":"Ibhayi","Jagthvlakte":"Jagthvlakte","Janssendal":"Janssendal","Jegelsville Village":"Jegelsville Village","Joung Park":"Joung Park","Jubilee Park":"Jubilee Park","Kabega":"Kabega","Kabega Park":"Kabega Park","Kamehs":"Kamehs","Kamma Heights":"Kamma Heights","Kamma Park":"Kamma Park","Kamma Ridge":"Kamma Ridge","Kensington":"Kensington","Khayamnandi":"Khayamnandi","Kleinskool":"Kleinskool","Korsten":"Korsten","Kunene Park":"Kunene Park","Kuscus Heights":"Kuscus Heights","Kwadwesi":"Kwadwesi","Kwaford":"Kwaford","Kwamagxaki":"Kwamagxaki","Kwanobuhle Area 1":"Kwanobuhle Area 1","Kwanobuhle Area 10":"Kwanobuhle Area 10","Kwanobuhle Area 11":"Kwanobuhle Area 11","Kwanobuhle Area 2":"Kwanobuhle Area 2","Kwanobuhle Area 3":"Kwanobuhle Area 3","Kwanobuhle Area 3A":"Kwanobuhle Area 3A","Kwanobuhle Area 4":"Kwanobuhle Area 4","Kwanobuhle Area 5":"Kwanobuhle Area 5","Kwanobuhle Area 6":"Kwanobuhle Area 6","Kwanobuhle Area 7":"Kwanobuhle Area 7","Kwanobuhle Area 8":"Kwanobuhle Area 8","Kwanobuhle Area 8A":"Kwanobuhle Area 8A","Kwanobuhle Area 9":"Kwanobuhle Area 9","Lakeside":"Lakeside","Linkside":"Linkside","Linton Grange":"Linton Grange","Loonatville":"Loonatville","Lorraine":"Lorraine","Lorraine Manor":"Lorraine Manor","Lovemore Heights":"Lovemore Heights","Malabar":"Malabar","Mangold Park":"Mangold Park","Manor Heights":"Manor Heights","Marais":"Marais","Markman Industrial Estate":"Markman Industrial Estate","Masangwanaville":"Masangwanaville","McNamee":"McNamee","McNaughton":"McNaughton","Mill Park":"Mill Park","Millard":"Millard","Miramar":"Miramar","Morningside":"Morningside","Mosel":"Mosel","Motherwell":"Motherwell","Mount Croix":"Mount Croix","Mount Pleasant":"Mount Pleasant","Mount Road":"Mount Road","Mountain View":"Mountain View","N.U.12":"N.U.12","Neave Industrial":"Neave Industrial","Newton Park":"Newton Park","Nickallsville":"Nickallsville","Normanville":"Normanville","North End":"North End","Overbaakens":"Overbaakens","Paisley":"Paisley","Palmridge":"Palmridge","Pari Park":"Pari Park","Parkside":"Parkside","Parsons Hill":"Parsons Hill","Parsons Vlei":"Parsons Vlei","Penford":"Penford","Perridgevale":"Perridgevale","Perseverance":"Perseverance","Pollockshaw":"Pollockshaw","Port Elizabeth Central":"Port Elizabeth Central","Providentia":"Providentia","Redhouse":"Redhouse","Reservoir Hills":"Reservoir Hills","Retief":"Retief","Richmond Hill":"Richmond Hill","Riverside Industrial":"Riverside Industrial","Rocky Ridge":"Rocky Ridge","Rosedale":"Rosedale","Rowallan Park":"Rowallan Park","Salisbury Park":"Salisbury Park","Salsoneville":"Salsoneville","Salt Lake":"Salt Lake","Sanctor":"Sanctor","Schauder":"Schauder","Schauderville":"Schauderville","Scheepershoogte":"Scheepershoogte","Schoenmakerskop":"Schoenmakerskop","Seaview":"Seaview","Sherwood":"Sherwood","Sidwell":"Sidwell","Silverwood":"Silverwood","Solomon Estate":"Solomon Estate","South End":"South End","Soweto-on-Sea":"Soweto-on-Sea","Springfield":"Springfield","St Georges Park":"St Georges Park","Steytler":"Steytler","Strelitzia Park":"Strelitzia Park","Summerstrand":"Summerstrand","Sunridge Park":"Sunridge Park","Swartkops":"Swartkops","Sydenham":"Sydenham","Tamboville":"Tamboville","Taybank":"Taybank","Theescombe AH":"Theescombe AH","Thomas Gamble":"Thomas Gamble","Thomas Jefthaville":"Thomas Jefthaville","Thornhill":"Thornhill","Tiryville":"Tiryville","Trehaven":"Trehaven","Valleisig":"Valleisig","Van der Stel":"Van der Stel","Van Riebeeckhoogte":"Van Riebeeckhoogte","Vanes Estate":"Vanes Estate","Veeplaas":"Veeplaas","Vergelegen":"Vergelegen","Vikingvale":"Vikingvale","Walmer":"Walmer","Walmer Downs":"Walmer Downs","Walmer Heights":"Walmer Heights","Walmer Township Gqebera":"Walmer Township Gqebera","Wells Estate":"Wells Estate","West End":"West End","Westering":"Westering","Weybridge  Park":"Weybridge  Park","William Moffet":"William Moffet","Willowdene":"Willowdene","Willowglen":"Willowglen","Windsor Park":"Windsor Park","Windvogel":"Windvogel","Witerhoek Park":"Witerhoek Park","Wonderview":"Wonderview","Woodlands":"Woodlands","Young Park":"Young Park"}},"Port Nolloth":{"items":{"CBD":"CBD"}},"Port Owen":{"items":{"CBD":"CBD"}},"Port Shepstone":{"items":{"Albersville":"Albersville","CBD":"CBD","Marburg":"Marburg","Oslo Beach":"Oslo Beach","Seapark":"Seapark"}},"Port St Johns":{"items":null},"Port Zimbali":{"items":null},"Porterville":{"items":null},"Postmasburg":{"items":null},"Potchefstroom":{"items":null},"Povall":{"items":null},"Pretoria":{"items":null},"Pretoria Rural":{"items":null},"Pretoriuskop":{"items":null},"Prieska":{"items":null},"Prince Albert":{"items":null},"Prince Alfred Hamlet":{"items":null},"Pringle Bay":{"items":null},"Pudumong":{"items":null},"Pullenshope":{"items":null},"Pumula":{"items":null},"Punda Maria":{"items":null},"Queenstown":{"items":null},"Qumbu":{"items":null},"Qwa-Qwa":{"items":null},"Radium":{"items":null},"Ramabesa":{"items":null},"Ramatlabama":{"items":null},"Ramsgate":{"items":null},"Randfontein":{"items":null},"Ratsiepane":{"items":null},"Rawsonville":{"items":null},"Rayton":{"items":null},"Rebone":{"items":null},"Reddersburg":{"items":null},"Redelinghuys":{"items":null},"Reebok":{"items":{"CBD":"CBD"}},"Refilwe":{"items":{"CBD":"CBD"}},"Reitz":{"items":{"CBD":"CBD"}},"Reivilo":{"items":{"CBD":"CBD"}},"Rennshaw":{"items":{"CBD":"CBD"}},"Rheenendal":{"items":{"CBD":"CBD"}},"Rhodes":{"items":{"CBD":"CBD"}},"Richards Bay":{"items":{"Alton":"Alton","Arboretum":"Arboretum","Birdswood":"Birdswood","CBD":"CBD","Meer en See":"Meer en See","Richards Bay Harbour":"Richards Bay Harbour"}},"Richmond - EC":{"items":{"Cannon Rocks":"Cannon Rocks","CBD":"CBD"}},"Richmond - KZN":{"items":{"CBD":"CBD"}},"Richmond - NC":{"items":{"CBD":"CBD"}},"Riebeeck Kasteel":{"items":{"CBD":"CBD"}},"Riebeeckstad":{"items":{"CBD":"CBD"}},"Riebeek East":{"items":{"CBD":"CBD"}},"Riebeek Wes":{"items":{"CBD":"CBD"}},"Rietkuil":{"items":null},"Rietpoel":{"items":null},"Rietspruit":{"items":null},"Rietspruit Mine":{"items":null},"Rita":{"items":null},"Ritchie":{"items":null},"Riversdale - WC":{"items":null},"Riviersonderend":{"items":null},"Robertson":{"items":null},"Rocky Drift":{"items":null},"Roedtan":{"items":null},"Roodepan":{"items":null},"Roodeplaat":{"items":null},"Roodewal":{"items":null},"Rooi Els":{"items":null},"Rooiberg":{"items":null},"Roossenekal":{"items":null},"Rosendal":{"items":null},"Rosetta":{"items":null},"Rouxville":{"items":null},"Ruigtesloot":{"items":null},"Rust De Winter":{"items":null},"Rustenburg":{"items":null},"Sabie":{"items":null},"Saldanha Bay":{"items":null},"Salt Rock":{"items":null},"San Lameer":{"items":null},"Sandbaai":{"items":null},"Sannieshof":{"items":null},"Santoy":{"items":null},"Saron":{"items":null},"Sasolburg":{"items":null},"Saulspoort":{"items":null},"Schagen":{"items":null},"Schoemansdal":{"items":null},"Schoemanskloof":{"items":null},"Schoemansville":{"items":null},"Schoongezicht":{"items":null},"Schweizer-Reneke":{"items":null},"Scottburgh":{"items":null},"Scottsville":{"items":null},"Sea View - EC":{"items":null},"Seabe":{"items":null},"Seafield":{"items":null},"Secunda":{"items":null},"Sedgefield":{"items":null},"Sekhukhune":{"items":null},"Selepe":{"items":null},"Sendelingsfontein":{"items":null},"Senekal":{"items":null},"Senwabarwana":{"items":null},"Senwamokgope":{"items":null},"Sesane":{"items":null},"Seshego":{"items":null},"Sespond":{"items":null},"Setabeng":{"items":null},"Setaria":{"items":null},"Setlagole":{"items":null},"Settlers":{"items":null},"Seven Oaks":{"items":null},"Sezela":{"items":null},"Shakaskraal":{"items":null},"Shayandima":{"items":null},"Sheepmoor":{"items":null},"Sheffield Beach":{"items":null},"Shelly Beach":{"items":null},"Shongweni":{"items":null},"Sibasa":{"items":null},"Sidbury":{"items":null},"Silkaatsnek":{"items":null},"Silverkrans":{"items":null},"Silwerkrans":{"items":null},"Simondium":{"items":null},"Sir Lowrys Pass":{"items":null},"Siyabuswa":{"items":null},"Skeerpoort":{"items":null},"Skuinsdrif":{"items":null},"Skukuza":{"items":null},"Slabberts":{"items":null},"Slurry":{"items":null},"Smithfield":{"items":null},"Sodwana Bay":{"items":null},"Somerset East":{"items":null},"Somerset West":{"items":null},"Sonop":{"items":null},"Soshanguve":{"items":null},"Southbroom":{"items":null},"Southey":{"items":null},"Southport":{"items":null},"Soutpan":{"items":null},"Spitskop":{"items":null},"Springbok":{"items":null},"Springfontein":{"items":null},"St Francis Bay":{"items":null},"St Helena Bay":{"items":null},"St Lucia":{"items":null},"St Michaels-on-Sea":{"items":null},"Staffords Post":{"items":null},"Standerton":{"items":null},"Stanford":{"items":null},"Stanger":{"items":null},"Steelpoort":{"items":null},"Steinkopf":{"items":null},"Stella":{"items":null},"Stellenbosch":{"items":null},"Sterkfontein":{"items":null},"Sterkrivier":{"items":null},"Sterkspruit":{"items":null},"Sterkstroom":{"items":null},"Steynsburg":{"items":null},"Steynsrus":{"items":null},"Steytlerville":{"items":null},"Stilfontein":{"items":null},"Stillbaai":{"items":null},"Stoffberg":{"items":null},"Stompneusbaai":{"items":null},"Stormsrivier":{"items":null},"Strand":{"items":null},"Struandale - PLZ":{"items":null},"Struisbaai":{"items":null},"Strydenburg":{"items":null},"Stutterheim":{"items":null},"Sudwala Lodge":{"items":null},"Sun City":{"items":null},"Sundra":{"items":null},"Sundumbili":{"items":null},"Sunland":{"items":null},"Sunwich Port":{"items":null},"Sutherland":{"items":null},"Swartberg":{"items":null},"Swartboom":{"items":null},"Swartklip":{"items":null},"Swartruggens":{"items":null},"Swartwater":{"items":null},"Swellendam":{"items":null},"Swinburne":{"items":null},"Syferkuil":{"items":null},"Taaibosbult":{"items":null},"Tabankulu":{"items":null},"Tafelkop":{"items":null},"Tala Valey":{"items":null},"Tarkastad":{"items":null},"Tarlton":{"items":null},"Tau Lekoa Mine":{"items":null},"Taung":{"items":null},"Taylors Halt":{"items":null},"Tekwane":{"items":null},"Temba":{"items":null},"Tergniet":{"items":null},"Thaba Nchu":{"items":null},"Thabazimbi":{"items":null},"The Crags":{"items":null},"Theunissen":{"items":null},"Thohoyandou":{"items":null},"Thornhill, EC":{"items":null},"Thornville":{"items":null},"Three Sisters":{"items":null},"Thulamahashe - A":{"items":null},"Thutlwane":{"items":null},"Tinley Manor":{"items":null},"Tladistad":{"items":null},"Tlakgameng":{"items":null},"Tlaseng":{"items":null},"Tlholwe":{"items":null},"Tolwe":{"items":null},"Tom Burke":{"items":null},"Tonga Village":{"items":null},"Tongaat":{"items":null},"Tosca":{"items":null},"Touws River":{"items":null},"Trawal":{"items":null},"Trichardsdall":{"items":null},"Trichardt":{"items":null},"Trompsburg":{"items":null},"Tseng":{"items":null},"Tseoge":{"items":null},"Tshetshu":{"items":null},"Tshidilamolomo":{"items":null},"Tshikondeni":{"items":null},"Tshipise":{"items":null},"Tsitsikamma":{"items":null},"Tsolo":{"items":null},"Tsomo":{"items":null},"Tugela Ferry":{"items":null},"Tugela Mouth":{"items":null},"Tulbagh":{"items":null},"Twee Riviere":{"items":null},"Tweefontein Mpumalanga":{"items":null},"Tweeling":{"items":null},"Tweespruit":{"items":null},"Tzaneen":{"items":null},"Ubombo":{"items":null},"Ugie":{"items":null},"Uitenhage":{"items":null},"Uitkyk":{"items":null},"Ulco":{"items":null},"Ulundi":{"items":null},"Umbumbulu":{"items":null},"Umdloti":{"items":null},"Umgababa":{"items":null},"Umhlali":{"items":null},"Umkomaas":{"items":null},"Umtata":{"items":null},"Umtentweni":{"items":null},"Umzimkulu":{"items":null},"Umzinto":{"items":null},"Umzumbe":{"items":null},"Underberg":{"items":null},"Uniondale":{"items":null},"Upington":{"items":null},"Utrecht":{"items":null},"Uvongo":{"items":null},"Vaal Marina":{"items":null},"Vaal Reef":{"items":null},"Vaalbank":{"items":null},"Vaalharts Nedersetting":{"items":null},"Vaalpark":{"items":null},"Vaalwater":{"items":null},"Valtaki":{"items":null},"Van Der Kloof":{"items":null},"Van Dyksdrif":{"items":null},"Van Reenen":{"items":null},"Van Stadens River Gorge":{"items":null},"Van Zylsrus":{"items":null},"Vanderbijlpark":{"items":null},"Vanrhynsdorp":{"items":null},"Vanstadensrus":{"items":null},"VanWyksdorp":{"items":null},"Vanwyksvlei":{"items":null},"Velddrif":{"items":null},"Ventersburg":{"items":null},"Ventersdorp":{"items":null},"Venterstad":{"items":null},"Vereeniging":{"items":null},"Verena":{"items":null},"Vergelee":{"items":null},"Verkeerdevlei":{"items":null},"Verkykerskop":{"items":null},"Vermaas":{"items":null},"Vermont":{"items":null},"Victoria West":{"items":null},"Viedgesville":{"items":null},"Vierfontein":{"items":null},"Viljoenskroon":{"items":null},"Villiers":{"items":null},"Villiersdorp":{"items":null},"Vioolsdrif":{"items":null},"Virginia":{"items":null},"Vivo":{"items":null},"Vleesbaai":{"items":null},"Vlottenburg":{"items":null},"Volksrust":{"items":null},"Vondwe":{"items":null},"Vosburg":{"items":null},"Vrede":{"items":null},"Vredefort":{"items":null},"Vredenburg":{"items":null},"Vredendal":{"items":null},"Vryburg":{"items":null},"Vryheid":{"items":null},"Vulindlela":{"items":null},"Vuwani":{"items":null},"Vyeboom":{"items":null},"Waburton":{"items":null},"Wakkerstroom":{"items":null},"Walman":{"items":null},"Walmansthal":{"items":null},"Warden":{"items":null},"Warner Beach":{"items":null},"Warrenton":{"items":null},"Wartburg":{"items":null},"Wasbank":{"items":null},"Waterfall":{"items":null},"Waterval Boven":{"items":null},"Waterval Onder":{"items":null},"Weenen":{"items":null},"Welkom":{"items":null},"Wellington":{"items":null},"Weltevrede":{"items":null},"Welverdiend":{"items":null},"Welverdiend Mine":{"items":null},"Wemmershoek":{"items":null},"Wepener":{"items":null},"Wesley":{"items":null},"Wesselsbron":{"items":null},"Westminister":{"items":null},"Westonaria":{"items":null},"Westville":{"items":null},"Weza":{"items":null},"White River":{"items":null},"Whitecliff":{"items":null},"Whittlesea":{"items":null},"Widenham":{"items":null},"Wilderness":{"items":null},"Wilgeboomspruit":{"items":null},"Williston":{"items":null},"Willowmore":{"items":null},"Willowvale":{"items":null},"Wilsonia":{"items":null},"Winburg":{"items":null},"Windsorton":{"items":null},"Winkelspruit":{"items":null},"Winterskloof":{"items":null},"Winterton":{"items":null},"Winterveld":{"items":null},"Witbank":{"items":null},"Witsand":{"items":null},"Wittedrif":{"items":null},"Wolmaranstad":{"items":null},"Wolseley":{"items":null},"Wolwehoek":{"items":null},"Wonderfontein":{"items":null},"Worcester":{"items":null},"Yzerfontein":{"items":null},"Zastron":{"items":null},"Zebediela":{"items":null},"Zeerust":{"items":null},"Zinkwazi":{"items":null},"Zinkwazi Beach":{"items":null},"Zithobeni":{"items":null},"Zwelitsha":{"items":null},"Zwide":{"items":null}}',true);
   /*     $mds = \MdsSupportingClasses\MdsColliveryService::getInstance();
        $selectedSuburb = null;
        if (get_current_user_id() > 0) {
            $selectedSuburb = $mds->extractUserProfileField(get_current_user_id(), $section.'suburb');
        }
            $collivery = $mds->returnColliveryClass();
            $towns = $collivery->getTowns();
            $return = array();
            foreach ($towns as $town_id => $town){
                $subs = get_transient( 'wc_coli_appmaker_town' . $town_id );
                if ( false === $subs) {
                    $subs = $collivery->getSuburbs($town_id);
                    set_transient( 'wc_coli_appmaker_town' . $town_id, $subs, 60 * 60 * 60 );
                    echo "\n - $town_id NO CACHE";
                    if($this->count > 5) exit;
                    $this->count++;
                }else{
                   // echo "\n - $town_id HAS CACHE";
                }

                $return[ $town ] = array( 'items' => array() );
                if ( is_array( $subs ) ) {
                    foreach ( $subs as $sub_id => $sub ) {
                        $return[ $town ]['items'][ $sub ] = html_entity_decode( $sub );
                    }
                }
                if ( empty( $return[ $town ]['items'] ) ) {
                    $return[ $town ]['items'] = null;
                }

            }

        echo json_encode($return);
        exit;*/
    }

    public static function suburb_dependency( $dependency, $key ) {
        if ( 'billing_suburb' === $key ) {
            $dependency = array( 'on' => 'billing_city' );
        } elseif ( 'shipping_suburb' === $key ) {
            $dependency = array( 'on' => 'shipping_city' );
        }

        return $dependency;
    }

}

new APPMAKER_WC_collivery_fields();
