<?php

include_once(QLWAPP_PLUGIN_DIR . 'includes/models/Display.php');

include_once(QLWAPP_PLUGIN_DIR . 'includes/controllers/QLWAPP_Controller.php');

class QLWAPP_Display_Controller extends QLWAPP_Controller {

  protected static $instance;

  function add_menu() {
    add_submenu_page(QLWAPP_DOMAIN, esc_html__('Display', 'wp-whatsapp-chat'), esc_html__('Display', 'wp-whatsapp-chat'), 'manage_options', QLWAPP_DOMAIN . '_display', array($this, 'add_panel'));
  }

  function add_panel() {
    $display_model = new QLWAPP_Display();
    $display = $display_model->get();
    include (QLWAPP_PLUGIN_DIR . '/includes/view/backend/pages/parts/header.php');
    include (QLWAPP_PLUGIN_DIR . '/includes/view/backend/pages/display.php');
  }

  function init() {
    add_action('wp_ajax_qlwapp_save_display', array($this, 'ajax_qlwapp_save_display'));
    add_action('admin_menu', array($this, 'add_menu'));
  }

  public function ajax_qlwapp_save_display() {
    $display = new QLWAPP_Display();
    if (current_user_can('manage_options')) {
      if (check_ajax_referer('qlwapp_save_display', 'nonce', false) && isset($_REQUEST['form_data'])) {
        $form_data = array();
        parse_str($_REQUEST['form_data'], $form_data);
        if (is_array($form_data)) {
          $display->save($form_data);
          return parent::success_save($form_data);
        }
        return parent::error_reload_page();
      }
      return parent::error_access_denied();
    }
  }

  //// debe ser de compatibilidatda
  function wac_options($options) {

    if ($mobile = get_option('whatsapp_chat_mobile')) {
      $options['display']['devices'] = 'mobile';
    }
    if (get_option('whatsapp_chat_hide_button')) {
      $options['display']['devices'] = 'hide';
    }
    if (get_option('whatsapp_chat_hide_post')) {
      $options['display']['post'] = array('none');
    }
    if (get_option('whatsapp_chat_hide_page')) {
      $options['display']['page'] = array('none');
    }
    if (get_option('whatsapp_chat_hide_product')) {
      $options['display']['product'] = array('none');
    }
    if (get_option('whatsapp_chat_hide_project')) {
      $options['display']['project'] = array('none');
    }

    return $options;
  }

  public static function instance() {
    if (!isset(self::$instance)) {
      self::$instance = new self();
      self::$instance->init();
    }
    return self::$instance;
  }

}

QLWAPP_Display_Controller::instance();
