<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

class Google_Service_SecretManager_Secret extends Google_Collection
{
  protected $collection_key = 'topics';
  public $createTime;
  public $etag;
  public $expireTime;
  public $labels;
  public $name;
  protected $replicationType = 'Google_Service_SecretManager_Replication';
  protected $replicationDataType = '';
  protected $rotationType = 'Google_Service_SecretManager_Rotation';
  protected $rotationDataType = '';
  protected $topicsType = 'Google_Service_SecretManager_Topic';
  protected $topicsDataType = 'array';
  public $ttl;

  public function setCreateTime($createTime)
  {
    $this->createTime = $createTime;
  }
  public function getCreateTime()
  {
    return $this->createTime;
  }
  public function setEtag($etag)
  {
    $this->etag = $etag;
  }
  public function getEtag()
  {
    return $this->etag;
  }
  public function setExpireTime($expireTime)
  {
    $this->expireTime = $expireTime;
  }
  public function getExpireTime()
  {
    return $this->expireTime;
  }
  public function setLabels($labels)
  {
    $this->labels = $labels;
  }
  public function getLabels()
  {
    return $this->labels;
  }
  public function setName($name)
  {
    $this->name = $name;
  }
  public function getName()
  {
    return $this->name;
  }
  /**
   * @param Google_Service_SecretManager_Replication
   */
  public function setReplication(Google_Service_SecretManager_Replication $replication)
  {
    $this->replication = $replication;
  }
  /**
   * @return Google_Service_SecretManager_Replication
   */
  public function getReplication()
  {
    return $this->replication;
  }
  /**
   * @param Google_Service_SecretManager_Rotation
   */
  public function setRotation(Google_Service_SecretManager_Rotation $rotation)
  {
    $this->rotation = $rotation;
  }
  /**
   * @return Google_Service_SecretManager_Rotation
   */
  public function getRotation()
  {
    return $this->rotation;
  }
  /**
   * @param Google_Service_SecretManager_Topic[]
   */
  public function setTopics($topics)
  {
    $this->topics = $topics;
  }
  /**
   * @return Google_Service_SecretManager_Topic[]
   */
  public function getTopics()
  {
    return $this->topics;
  }
  public function setTtl($ttl)
  {
    $this->ttl = $ttl;
  }
  public function getTtl()
  {
    return $this->ttl;
  }
}
